/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.foundation.collections;

import java.lang.ref.WeakReference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterableResultSet
implements Iterable<Map<String, Object>> {
    protected static final Map<ResultSet, IterableResultSet> iterables = new WeakHashMap<ResultSet, IterableResultSet>();
    protected final WeakReference<ResultSet> resultRef;

    public IterableResultSet(ResultSet result) {
        if (iterables.containsKey(result)) {
            throw new RuntimeException("Cannot have two IterableResultSet wrappers around the same resultset.");
        }
        this.resultRef = new WeakReference<ResultSet>(result);
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        if (this.resultRef.get() == null) {
            throw new RuntimeException("ResultSet object not available to iterate.");
        }
        return new ResultSetIterator((ResultSet)this.resultRef.get());
    }

    public void dispose() {
        ResultSet rs = (ResultSet)this.resultRef.get();
        if (rs == null) {
            return;
        }
        if (iterables.containsKey(rs)) {
            iterables.get(rs).dispose();
        }
        this.resultRef.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResultSetIterator
    implements Iterator<Map<String, Object>> {
        private static final Logger logger = Logger.getLogger(ResultSetIterator.class.getName());
        protected ResultSet result;
        boolean hasNext = true;

        public ResultSetIterator(ResultSet result) {
            this.result = result;
            try {
                this.hasNext = result.first();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Map<String, Object> next() {
            try {
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (int i = 1; i <= this.result.getMetaData().getColumnCount(); ++i) {
                    row.put(this.result.getMetaData().getColumnName(i), this.result.getObject(i));
                }
                this.hasNext = this.result.next();
                return row;
            }
            catch (SQLException e) {
                logger.log(Level.FINER, "SQLException thrown while iterating across result set.", e);
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removal of records from underlying result set not supported.");
        }

        public void dispose() {
            if (iterables.containsKey(this.result)) {
                iterables.remove(this.result);
            }
            this.result = null;
        }

        public void finalize() throws Throwable {
            this.dispose();
            super.finalize();
        }
    }
}

