/*
 * Copyright (c) 2003, 2004, 2005, 2006 Israfil Consulting Services Corporation
 * Copyright (c) 2003, 2004, 2005, 2006 Christian Edward Gruber
 * All Rights Reserved
 * 
 * This software is licensed under the Berkeley Standard Distribution license,
 * (BSD license), as defined below:
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this 
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of Israfil Consulting Services nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 * 
 * $Id: ArraySet.java 76 2006-08-03 15:37:05Z cgruber $
 */
package net.israfil.foundation.collections;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

import net.israfil.foundation.core.Copyright;

/**
 * An ArrayList backed Set implementation, whose primary purpose is
 * to provide a Set that maintains the order of elements based on
 * indexes and/or the order in which items are added.  Most 
 * particularly it's to guarrantee deterministic results of an
 * iterator, where the iterator provides each element in the order
 * of the underlying list.
 * 
 * Note that the current implementation is limited, insofar as you 
 * cannot get arraylist-like behaviour from it such as inserting.
 * You can add, and it's a bit like a stack-set, actually.  
 * 
 * TODO: Consider making this a SortedSet, using the list order as the guarrantee.  Not sure if it's a legit use of the API.
 * 
 * @author <a href="mailto:cgruber@israfil.net">Christian Edward Gruber </a>
 */
@Copyright(years={"2003","2004","2005","2006"},owner="Israfil Consulting Services Corporation",license="BSD")
public class ArraySet<E> extends AbstractSet<E>  {

	private transient ArrayList<E> internalList;
	
	public ArraySet() {
		internalList = new ArrayList<E>();
	}

	public ArraySet(int initialCapacity) {
		internalList = new ArrayList<E>(initialCapacity);
	}
	
	public ArraySet(Collection<E> col) {
		internalList = new ArrayList<E>(col);
		Iterator<E> i = col.iterator();
		while (i.hasNext()) {
			internalList.add(i.next());
		}
	}

	@Override
	public Iterator<E> iterator() {
		new HashSet();
		return internalList.iterator();
		
	}

	@Override
	public int size() {
		return internalList.size();
	}

	@Override
	public boolean add(E o) {
		if (internalList.contains(o)) return false;
		else {
			internalList.add(o);
			return true;
		}
	}

	@Override
	public boolean remove(Object o) {
		return internalList.remove(o);
	}
	
}
