/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.util;

import org.logicalcobwebs.proxool.util.ListenerContainerIF;

public abstract class AbstractListenerContainer
implements ListenerContainerIF {
    private Object[] listeners = EMPTY_LISTENERS;
    private static final Object[] EMPTY_LISTENERS = new Object[0];

    @Override
    public synchronized void addListener(Object listener) {
        if (listener == null) {
            throw new NullPointerException("Unexpected NULL listener argument received");
        }
        Object[] newListeners = new Object[this.listeners.length + 1];
        System.arraycopy(this.listeners, 0, newListeners, 0, this.listeners.length);
        newListeners[this.listeners.length] = listener;
        this.listeners = newListeners;
    }

    @Override
    public synchronized boolean removeListener(Object listener) {
        if (listener == null) {
            throw new NullPointerException("Unexpected NULL listener argument received");
        }
        int index = -1;
        for (int i = 0; i < this.listeners.length; ++i) {
            if (this.listeners[i] != listener) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return false;
        }
        Object[] newListeners = new Object[this.listeners.length - 1];
        if (index > 0) {
            System.arraycopy(this.listeners, 0, newListeners, 0, index);
        }
        if (index < this.listeners.length - 1) {
            System.arraycopy(this.listeners, index + 1, newListeners, index, this.listeners.length - index - 1);
        }
        this.listeners = newListeners;
        return true;
    }

    protected Object[] getListeners() {
        return this.listeners;
    }

    @Override
    public boolean isEmpty() {
        return this.listeners.length == 0;
    }
}

