/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.admin.servlet;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.logicalcobwebs.proxool.ConnectionInfoIF;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.Version;
import org.logicalcobwebs.proxool.admin.SnapshotIF;
import org.logicalcobwebs.proxool.admin.StatisticsIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminServlet
extends HttpServlet {
    private static final long serialVersionUID = 1511402423570704280L;
    private static final Logger LOG = LoggerFactory.getLogger(AdminServlet.class);
    private static final String[] STATUS_CLASSES = new String[]{"null", "available", "active", "offline"};
    public static final String OUTPUT_FULL = "full";
    public static final String OUTPUT_SIMPLE = "simple";
    private String output;
    private String cssFile;
    private static final String STATISTIC = "statistic";
    private static final String CORE_PROPERTY = "core-property";
    private static final String STANDARD_PROPERTY = "standard-property";
    private static final String DELEGATED_PROPERTY = "delegated-property";
    private static final String SNAPSHOT = "snapshot";
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private static final String DETAIL = "detail";
    private static final String DETAIL_MORE = "more";
    private static final String DETAIL_LESS = "less";
    private static final String TAB = "tab";
    private static final String TAB_DEFINITION = "definition";
    private static final String TAB_SNAPSHOT = "snapshot";
    private static final String TAB_STATISTICS = "statistics";
    private static final String ALIAS = "alias";
    private static final String CONNECTION_ID = "id";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.output = servletConfig.getInitParameter("output");
        if (this.output != null) {
            if (this.output.equalsIgnoreCase(OUTPUT_FULL)) {
                this.output = OUTPUT_FULL;
            } else if (this.output.equalsIgnoreCase(OUTPUT_SIMPLE)) {
                this.output = OUTPUT_SIMPLE;
            } else {
                LOG.warn("Unrecognised output parameter for " + ((Object)((Object)this)).getClass().getName() + ". Expected: " + OUTPUT_FULL + " or " + OUTPUT_SIMPLE);
                this.output = null;
            }
        }
        if (this.output == null) {
            this.output = OUTPUT_FULL;
        }
        this.cssFile = servletConfig.getInitParameter("cssFile");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block16: {
            String tab;
            response.setHeader("Pragma", "no-cache");
            String link = request.getRequestURI();
            String alias = request.getParameter(ALIAS);
            ConnectionPoolDefinitionIF def = null;
            if (alias != null) {
                try {
                    def = ProxoolFacade.getConnectionPoolDefinition(alias);
                }
                catch (ProxoolException e) {
                    alias = null;
                }
            }
            String[] aliases = ProxoolFacade.getAliases();
            if (alias == null && aliases.length > 0) {
                alias = aliases[0];
            }
            if (def == null && alias != null) {
                try {
                    def = ProxoolFacade.getConnectionPoolDefinition(alias);
                }
                catch (ProxoolException e) {
                    throw new ServletException("Couldn't find pool with alias " + alias);
                }
            }
            if ((tab = request.getParameter(TAB)) == null) {
                tab = TAB_DEFINITION;
            }
            String snapshotDetail = request.getParameter(DETAIL);
            String snapshotConnectionId = request.getParameter(CONNECTION_ID);
            try {
                boolean statisticsComingSoon;
                if (this.output.equals(OUTPUT_FULL)) {
                    response.setContentType("text/html");
                    this.openHtml(response.getOutputStream());
                }
                response.getOutputStream().println("<div class=\"version\">Proxool " + Version.getVersion() + "</div>");
                this.doList(response.getOutputStream(), alias, tab, link);
                if (aliases == null || aliases.length <= 0) break block16;
                StatisticsIF[] statisticsArray = ProxoolFacade.getStatistics(alias);
                boolean statisticsAvailable = statisticsArray != null && statisticsArray.length > 0;
                boolean bl = statisticsComingSoon = def.getStatistics() != null;
                if (!statisticsComingSoon && tab.equals(TAB_STATISTICS)) {
                    tab = TAB_DEFINITION;
                }
                this.doTabs(response.getOutputStream(), alias, link, tab, statisticsAvailable, statisticsComingSoon);
                if (tab.equals(TAB_DEFINITION)) {
                    this.doDefinition(response.getOutputStream(), def);
                    break block16;
                }
                if (tab.equals("snapshot")) {
                    this.doSnapshot(response.getOutputStream(), def, link, snapshotDetail, snapshotConnectionId);
                    break block16;
                }
                if (tab.equals(TAB_STATISTICS)) {
                    this.doStatistics(response.getOutputStream(), statisticsArray, def);
                    break block16;
                }
                throw new ServletException("Unrecognised tab '" + tab + "'");
            }
            catch (ProxoolException e) {
                throw new ServletException("Problem serving Proxool Admin", (Throwable)e);
            }
        }
        if (this.output.equals(OUTPUT_FULL)) {
            this.closeHtml(response.getOutputStream());
        }
    }

    private void doTabs(ServletOutputStream out, String alias, String link, String tab, boolean statisticsAvailable, boolean statisticsComingSoon) throws IOException {
        out.println("<ul>");
        out.println("<li class=\"" + (tab.equals(TAB_DEFINITION) ? "active" : "inactive") + "\"><a class=\"quiet\" href=\"" + link + "?alias=" + alias + "&tab=" + TAB_DEFINITION + "\">Definition</a></li>");
        out.println("<li class=\"" + (tab.equals("snapshot") ? "active" : "inactive") + "\"><a class=\"quiet\" href=\"" + link + "?alias=" + alias + "&tab=" + "snapshot" + "\">Snapshot</a></li>");
        if (statisticsAvailable) {
            out.println("<li class=\"" + (tab.equals(TAB_STATISTICS) ? "active" : "inactive") + "\"><a class=\"quiet\" href=\"" + link + "?alias=" + alias + "&tab=" + TAB_STATISTICS + "\">Statistics</a></li>");
        } else if (statisticsComingSoon) {
            out.println("<li class=\"disabled\">Statistics</li>");
        }
        out.println("</ul>");
    }

    private void doStatistics(ServletOutputStream out, StatisticsIF[] statisticsArray, ConnectionPoolDefinitionIF cpd) throws IOException {
        for (int i = 0; i < statisticsArray.length; ++i) {
            StatisticsIF statistics = statisticsArray[i];
            this.openDataTable(out);
            this.printDefinitionEntry(out, ALIAS, cpd.getAlias(), CORE_PROPERTY);
            this.printDefinitionEntry(out, "Period", TIME_FORMAT.format(statistics.getStartDate()) + " to " + TIME_FORMAT.format(statistics.getStopDate()), STATISTIC);
            this.printDefinitionEntry(out, "Served", statistics.getServedCount() + " (" + DECIMAL_FORMAT.format(statistics.getServedPerSecond()) + "/s)", STATISTIC);
            this.printDefinitionEntry(out, "Refused", statistics.getRefusedCount() + " (" + DECIMAL_FORMAT.format(statistics.getRefusedPerSecond()) + "/s)", STATISTIC);
            this.printDefinitionEntry(out, "Average active time", DECIMAL_FORMAT.format(statistics.getAverageActiveTime() / 1000.0) + "s", STATISTIC);
            StringBuffer activityLevelBuffer = new StringBuffer();
            int activityLevel = (int)(100.0 * statistics.getAverageActiveCount() / (double)cpd.getMaximumConnectionCount());
            activityLevelBuffer.append(activityLevel);
            activityLevelBuffer.append("%<br/>");
            String[] colours = new String[]{"0000ff", "eeeeee"};
            int[] lengths = new int[]{activityLevel, 100 - activityLevel};
            this.drawBarChart(activityLevelBuffer, colours, lengths);
            this.printDefinitionEntry(out, "Activity level", activityLevelBuffer.toString(), STATISTIC);
            this.closeTable(out);
        }
    }

    private void drawBarChart(StringBuffer out, String[] colours, int[] lengths) {
        out.append("<table style=\"margin: 8px; font-size: 50%;\" width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr>");
        int totalLength = 0;
        for (int i = 0; i < colours.length; ++i) {
            totalLength += lengths[i];
        }
        for (int j = 0; j < colours.length; ++j) {
            String colour = colours[j];
            int length = lengths[j];
            if (length <= 0) continue;
            out.append("<td style=\"background-color: #");
            out.append(colour);
            out.append("\" width=\"");
            out.append(100 * length / totalLength);
            out.append("%\">&nbsp;</td>");
        }
        out.append("</tr></table>");
    }

    private void doDefinition(ServletOutputStream out, ConnectionPoolDefinitionIF cpd) throws IOException {
        this.openDataTable(out);
        this.printDefinitionEntry(out, ALIAS, cpd.getAlias(), CORE_PROPERTY);
        this.printDefinitionEntry(out, "driver-url", cpd.getUrl(), CORE_PROPERTY);
        this.printDefinitionEntry(out, "driver-class", cpd.getDriver(), CORE_PROPERTY);
        this.printDefinitionEntry(out, "minimum-connection-count", String.valueOf(cpd.getMinimumConnectionCount()), STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "maximum-connection-count", String.valueOf(cpd.getMaximumConnectionCount()), STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "prototype-count", cpd.getPrototypeCount() > 0 ? String.valueOf(cpd.getPrototypeCount()) : null, STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "simultaneous-build-throttle", String.valueOf(cpd.getSimultaneousBuildThrottle()), STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "maximum-connection-lifetime", this.formatMilliseconds(cpd.getMaximumConnectionLifetime()), STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "maximum-active-time", this.formatMilliseconds(cpd.getMaximumActiveTime()), STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "house-keeping-sleep-time", cpd.getHouseKeepingSleepTime() / 1000L + "s", STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "house-keeping-test-sql", cpd.getHouseKeepingTestSql(), STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "test-before-use", String.valueOf(cpd.isTestBeforeUse()), STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "test-after-use", String.valueOf(cpd.isTestAfterUse()), STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "recently-started-threshold", this.formatMilliseconds(cpd.getRecentlyStartedThreshold()), STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "overload-without-refusal-lifetime", this.formatMilliseconds(cpd.getOverloadWithoutRefusalLifetime()), STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "injectable-connection-interface", String.valueOf(cpd.getInjectableConnectionInterface()), STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "injectable-statement-interface", String.valueOf(cpd.getInjectableStatementInterface()), STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "injectable-callable-statement-interface", String.valueOf(cpd.getInjectableCallableStatementInterface()), STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "injectable-prepared-statement-interface", String.valueOf(cpd.getInjectablePreparedStatementInterface()), STANDARD_PROPERTY);
        String fatalSqlExceptions = null;
        if (cpd.getFatalSqlExceptions() != null && cpd.getFatalSqlExceptions().size() > 0) {
            StringBuffer fatalSqlExceptionsBuffer = new StringBuffer();
            Iterator<Object> i = cpd.getFatalSqlExceptions().iterator();
            while (i.hasNext()) {
                String string = (String)i.next();
                fatalSqlExceptionsBuffer.append(string);
                fatalSqlExceptionsBuffer.append(i.hasNext() ? ", " : "");
            }
            fatalSqlExceptions = fatalSqlExceptionsBuffer.toString();
        }
        this.printDefinitionEntry(out, "fatal-sql-exception", fatalSqlExceptions, STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "fatal-sql-exception-wrapper-class", cpd.getFatalSqlExceptionWrapper(), STANDARD_PROPERTY);
        this.printDefinitionEntry(out, TAB_STATISTICS, cpd.getStatistics(), STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "statistics-log-level", cpd.getStatisticsLogLevel(), STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "verbose", String.valueOf(cpd.isVerbose()), STANDARD_PROPERTY);
        this.printDefinitionEntry(out, "trace", String.valueOf(cpd.isTrace()), STANDARD_PROPERTY);
        Properties p = cpd.getDelegateProperties();
        for (String string : p.keySet()) {
            String value = p.getProperty(string);
            if (string.toLowerCase().indexOf("password") > -1 || string.toLowerCase().indexOf("passwd") > -1) {
                value = "******";
            }
            this.printDefinitionEntry(out, string + " (delegated)", value, DELEGATED_PROPERTY);
        }
        this.closeTable(out);
    }

    private void doSnapshot(ServletOutputStream out, ConnectionPoolDefinitionIF cpd, String link, String level, String connectionId) throws IOException, ProxoolException {
        boolean detail = level != null && level.equals(DETAIL_MORE);
        SnapshotIF snapshot = ProxoolFacade.getSnapshot(cpd.getAlias(), detail);
        if (snapshot != null) {
            this.openDataTable(out);
            this.printDefinitionEntry(out, ALIAS, cpd.getAlias(), CORE_PROPERTY);
            this.printDefinitionEntry(out, "Start date", DATE_FORMAT.format(snapshot.getDateStarted()), "snapshot");
            this.printDefinitionEntry(out, "Snapshot", TIME_FORMAT.format(snapshot.getSnapshotDate()), "snapshot");
            StringBuffer connectionsBuffer = new StringBuffer();
            connectionsBuffer.append(snapshot.getActiveConnectionCount());
            connectionsBuffer.append(" (active), ");
            connectionsBuffer.append(snapshot.getAvailableConnectionCount());
            connectionsBuffer.append(" (available), ");
            if (snapshot.getOfflineConnectionCount() > 0) {
                connectionsBuffer.append(snapshot.getOfflineConnectionCount());
                connectionsBuffer.append(" (offline), ");
            }
            connectionsBuffer.append(snapshot.getMaximumConnectionCount());
            connectionsBuffer.append(" (max)<br/>");
            String[] colours = new String[]{"ff9999", "66cc66", "cccccc"};
            int[] lengths = new int[]{snapshot.getActiveConnectionCount(), snapshot.getAvailableConnectionCount(), snapshot.getMaximumConnectionCount() - snapshot.getActiveConnectionCount() - snapshot.getAvailableConnectionCount()};
            this.drawBarChart(connectionsBuffer, colours, lengths);
            this.printDefinitionEntry(out, "Connections", connectionsBuffer.toString(), "snapshot");
            this.printDefinitionEntry(out, "Served", String.valueOf(snapshot.getServedCount()), "snapshot");
            this.printDefinitionEntry(out, "Refused", String.valueOf(snapshot.getRefusedCount()), "snapshot");
            if (!detail) {
                out.println("    <tr>");
                out.print("        <td colspan=\"2\" align=\"right\"><form action=\"" + link + "\" method=\"GET\">");
                out.print("<input type=\"hidden\" name=\"alias\" value=\"" + cpd.getAlias() + "\">");
                out.print("<input type=\"hidden\" name=\"tab\" value=\"snapshot\">");
                out.print("<input type=\"hidden\" name=\"detail\" value=\"more\">");
                out.print("<input type=\"submit\" value=\"More information&gt;\">");
                out.println("</form></td>");
                out.println("    </tr>");
            } else {
                long drillDownConnectionId;
                ConnectionInfoIF drillDownConnection;
                out.println("    <tr>");
                out.print("      <th width=\"200\" valign=\"top\">");
                out.print("Details:<br>(click ID to drill down)");
                out.println("</th>");
                out.print("      <td>");
                this.doSnapshotDetails(out, cpd, snapshot, link, connectionId);
                out.println("</td>");
                out.println("    </tr>");
                if (connectionId != null && (drillDownConnection = snapshot.getConnectionInfo(drillDownConnectionId = Long.valueOf(connectionId).longValue())) != null) {
                    out.println("    <tr>");
                    out.print("      <th valign=\"top\">");
                    out.print("Connection #" + connectionId);
                    out.println("</td>");
                    out.print("      <td>");
                    this.doDrillDownConnection(out, drillDownConnection);
                    out.println("</td>");
                    out.println("    </tr>");
                }
                out.println("    <tr>");
                out.print("        <td colspan=\"2\" align=\"right\"><form action=\"" + link + "\" method=\"GET\">");
                out.print("<input type=\"hidden\" name=\"alias\" value=\"" + cpd.getAlias() + "\">");
                out.print("<input type=\"hidden\" name=\"tab\" value=\"snapshot\">");
                out.print("<input type=\"hidden\" name=\"detail\" value=\"less\">");
                out.print("<input type=\"submit\" value=\"&lt; Less information\">");
                out.println("</form></td>");
                out.println("    </tr>");
            }
            this.closeTable(out);
        }
    }

    private void doSnapshotDetails(ServletOutputStream out, ConnectionPoolDefinitionIF cpd, SnapshotIF snapshot, String link, String connectionId) throws IOException {
        long drillDownConnectionId = 0L;
        if (connectionId != null) {
            drillDownConnectionId = Long.valueOf(connectionId);
        }
        if (snapshot.getConnectionInfos() != null && snapshot.getConnectionInfos().length > 0) {
            out.println("<table cellpadding=\"2\" cellspacing=\"0\" border=\"0\">");
            out.println("  <tbody>");
            out.print("<tr>");
            out.print("<td>#</td>");
            out.print("<td align=\"center\">born</td>");
            out.print("<td align=\"center\">last<br>start</td>");
            out.print("<td align=\"center\">lap<br>(ms)</td>");
            out.print("<td>&nbsp;thread</td>");
            out.print("</tr>");
            ConnectionInfoIF[] connectionInfos = snapshot.getConnectionInfos();
            for (int i = 0; i < connectionInfos.length; ++i) {
                ConnectionInfoIF connectionInfo = connectionInfos[i];
                if (connectionInfo.getStatus() == 0) continue;
                out.print("<tr>");
                out.print("<td style=\"background-color: #");
                if (connectionInfo.getStatus() == 2) {
                    out.print("ffcccc");
                } else if (connectionInfo.getStatus() == 1) {
                    out.print("ccffcc");
                } else if (connectionInfo.getStatus() == 3) {
                    out.print("ccccff");
                }
                out.print("\" style=\"");
                if (drillDownConnectionId == connectionInfo.getId()) {
                    out.print("border: 1px solid black;");
                    out.print("\">");
                    out.print(connectionInfo.getId());
                } else {
                    out.print("border: 1px solid transparent;");
                    out.print("\"><a href=\"");
                    out.print(link);
                    out.print("?");
                    out.print(ALIAS);
                    out.print("=");
                    out.print(cpd.getAlias());
                    out.print("&");
                    out.print(TAB);
                    out.print("=");
                    out.print("snapshot");
                    out.print("&");
                    out.print(DETAIL);
                    out.print("=");
                    out.print(DETAIL_MORE);
                    out.print("&");
                    out.print(CONNECTION_ID);
                    out.print("=");
                    out.print(connectionInfo.getId());
                    out.print("\">");
                    out.print(connectionInfo.getId());
                    out.print("</a>");
                }
                out.print("</td>");
                out.print("<td>&nbsp;");
                out.print(TIME_FORMAT.format(connectionInfo.getBirthDate()));
                out.print("</td>");
                out.print("<td>&nbsp;");
                out.print(connectionInfo.getTimeLastStartActive() > 0L ? TIME_FORMAT.format(new Date(connectionInfo.getTimeLastStartActive())) : "-");
                out.print("</td>");
                out.print("<td align=\"right\" class=\"");
                out.print(AdminServlet.getStatusClass(connectionInfo));
                out.print("\">");
                String active = "&nbsp;";
                if (connectionInfo.getTimeLastStopActive() > 0L) {
                    active = String.valueOf((int)(connectionInfo.getTimeLastStopActive() - connectionInfo.getTimeLastStartActive()));
                } else if (connectionInfo.getTimeLastStartActive() > 0L) {
                    active = String.valueOf((int)(snapshot.getSnapshotDate().getTime() - connectionInfo.getTimeLastStartActive()));
                }
                out.print(active);
                out.print("&nbsp;&nbsp;</td>");
                out.print("<td>&nbsp;");
                out.print(connectionInfo.getRequester() != null ? connectionInfo.getRequester() : "-");
                out.print("</td>");
                out.println("</tr>");
            }
            out.println("  </tbody>");
            out.println("</table>");
        } else {
            out.println("No connections yet");
        }
    }

    private static String getStatusClass(ConnectionInfoIF info) {
        try {
            return STATUS_CLASSES[info.getStatus()];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.warn("Unknown status: " + info.getStatus());
            return "unknown-" + info.getStatus();
        }
    }

    private void doDrillDownConnection(ServletOutputStream out, ConnectionInfoIF drillDownConnection) throws IOException {
        String[] sqlCalls = drillDownConnection.getSqlCalls();
        for (int i = 0; sqlCalls != null && i < sqlCalls.length; ++i) {
            String sqlCall = sqlCalls[i];
            out.print("<div class=\"drill-down\">");
            out.print("sql = ");
            out.print(sqlCall);
            out.print("</div>");
        }
        out.print("<div class=\"drill-down\">");
        out.print("proxy = ");
        out.print(drillDownConnection.getProxyHashcode());
        out.print("</div>");
        out.print("<div class=\"drill-down\">");
        out.print("delegate = ");
        out.print(drillDownConnection.getDelegateHashcode());
        out.print("</div>");
        out.print("<div class=\"drill-down\">");
        out.print("url = ");
        out.print(drillDownConnection.getDelegateUrl());
        out.print("</div>");
    }

    private void openHtml(ServletOutputStream out) throws IOException {
        out.println("<html><header><title>Proxool Admin</title>");
        out.println("<style media=\"screen\">");
        out.println("body {background-color: #93bde6;}\ndiv.version {font-weight: bold; font-size: 100%; margin-bottom: 8px;}\nh1 {font-weight: bold; font-size: 100%}\noption {padding: 2px 24px 2px 4px;}\ninput {margin: 0px 0px 4px 12px;}\ntable.data {font-size: 90%; border-collapse: collapse; border: 1px solid black;}\ntable.data th {background: #bddeff; width: 25em; text-align: left; padding-right: 8px; font-weight: normal; border: 1px solid black;}\ntable.data td {background: #ffffff; vertical-align: top; padding: 0px 2px 0px 2px; border: 1px solid black;}\ntd.null {background: yellow;}\ntd.available {color: black;}\ntd.active {color: red;}\ntd.offline {color: blue;}\ndiv.drill-down {}\nul {list-style: none; padding: 0px; margin: 0px; position: relative; font-size: 90%;}\nli {padding: 0px; margin: 0px 4px 0px 0px; display: inline; border: 1px solid black; border-width: 1px 1px 0px 1px;}\nli.active {background: #bddeff;}\nli.inactive {background: #eeeeee;}\nli.disabled {background: #dddddd; color: #999999; padding: 0px 4px 0px 4px;}\na.quiet {color: black; text-decoration: none; padding: 0px 4px 0px 4px; }\na.quiet:hover {background: white;}\n");
        out.println("</style>");
        if (this.cssFile != null) {
            out.println("<link rel=\"stylesheet\" media=\"screen\" type=\"text/css\" href=\"" + this.cssFile + "\"></script>");
        }
        out.println("</header><body>");
    }

    private void closeHtml(ServletOutputStream out) throws IOException {
        out.println("</body></html>");
    }

    private void openDataTable(ServletOutputStream out) throws IOException {
        out.println("<table cellpadding=\"2\" cellspacing=\"0\" border=\"1\" class=\"data\">");
        out.println("  <tbody>");
    }

    private void closeTable(ServletOutputStream out) throws IOException {
        out.println("  </tbody>");
        out.println("</table>");
        out.println("<br/>");
    }

    private void printDefinitionEntry(ServletOutputStream out, String name, String value, String type) throws IOException {
        out.println("    <tr>");
        out.print("      <th valign=\"top\">");
        out.print(name);
        out.println(":</th>");
        out.print("      <td class=\"" + type + "\"nowrap>");
        if (value != null && !value.equals("null")) {
            out.print(value);
        } else {
            out.print("-");
        }
        out.print("</td>");
        out.println("    </tr>");
    }

    private void doList(ServletOutputStream out, String alias, String tab, String link) throws IOException {
        String[] aliases = ProxoolFacade.getAliases();
        if (aliases.length == 0) {
            out.println("<p>No pools have been registered.</p>");
        } else if (aliases.length != 1) {
            out.println("<form action=\"" + link + "\" method=\"GET\" name=\"alias\">");
            out.println("<select name=\"alias\" size=\"" + Math.min(aliases.length, 5) + "\">");
            for (int i = 0; i < aliases.length; ++i) {
                out.print("  <option value=\"");
                out.print(aliases[i]);
                out.print("\"");
                out.print(aliases[i].equals(alias) ? " selected" : "");
                out.print(">");
                out.print(aliases[i]);
                out.println("</option>");
            }
            out.println("</select>");
            out.println("<input name=\"tab\" value=\"" + tab + "\" type=\"hidden\">");
            out.println("<input value=\"Show\" type=\"submit\">");
            out.println("</form>");
        }
    }

    private String formatMilliseconds(long time) {
        if (time > Integer.MAX_VALUE) {
            return time + "ms";
        }
        Calendar c = Calendar.getInstance();
        c.clear();
        c.add(14, (int)time);
        return TIME_FORMAT.format(c.getTime());
    }
}

