/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.logicalcobwebs.proxool.FatalSqlExceptionHelper;
import org.logicalcobwebs.proxool.ProxyConnection;
import org.logicalcobwebs.proxool.ProxyFactory;
import org.logicalcobwebs.proxool.proxy.InvokerFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrappedConnection
implements MethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(WrappedConnection.class);
    private static final String CLOSE_METHOD = "close";
    private static final String IS_CLOSED_METHOD = "isClosed";
    private static final String EQUALS_METHOD = "equals";
    private static final String GET_META_DATA_METHOD = "getMetaData";
    private static final String FINALIZE_METHOD = "finalize";
    private static final String HASH_CODE_METHOD = "hashCode";
    private static final String TO_STRING_METHOD = "toString";
    private ProxyConnection proxyConnection;
    private long id;
    private String alias;
    private boolean manuallyClosed;

    public WrappedConnection(ProxyConnection proxyConnection) {
        this.proxyConnection = proxyConnection;
        this.id = proxyConnection.getId();
        this.alias = proxyConnection.getDefinition().getAlias();
    }

    public ProxyConnection getProxyConnection() {
        return this.proxyConnection;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        return this.invoke(proxy, method, args);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        int argCount = args != null ? args.length : 0;
        Method concreteMethod = method;
        if (this.proxyConnection != null && this.proxyConnection.getConnection() != null) {
            concreteMethod = InvokerFacade.getConcreteMethod(this.proxyConnection.getConnection().getClass(), method);
        }
        try {
            if (this.proxyConnection != null && this.proxyConnection.isReallyClosed() && !concreteMethod.getName().equals(IS_CLOSED_METHOD) && !concreteMethod.getName().equals(CLOSE_METHOD)) {
                if (!this.manuallyClosed) throw new SQLException("You can't perform any operations on this connection. It has been automatically closed by Proxool for some reason (see logs).");
                throw new SQLException("You can't perform any operations on a connection after you've called close()");
            }
            if (concreteMethod.getName().equals(CLOSE_METHOD)) {
                if (this.proxyConnection != null && !this.proxyConnection.isReallyClosed()) {
                    this.proxyConnection.close();
                    this.proxyConnection = null;
                    this.manuallyClosed = true;
                }
            } else if (concreteMethod.getName().equals(EQUALS_METHOD) && argCount == 1) {
                result = this.equals(args[0]) ? Boolean.TRUE : Boolean.FALSE;
            } else if (concreteMethod.getName().equals(HASH_CODE_METHOD) && argCount == 0) {
                result = new Integer(this.hashCode());
            } else if (concreteMethod.getName().equals(IS_CLOSED_METHOD) && argCount == 0) {
                result = this.proxyConnection == null || this.proxyConnection.isClosed() ? Boolean.TRUE : Boolean.FALSE;
            } else if (concreteMethod.getName().equals(GET_META_DATA_METHOD) && argCount == 0) {
                if (this.proxyConnection == null) throw new SQLException("You can't perform a " + concreteMethod.getName() + " operation after the connection has been closed");
                Connection connection = ProxyFactory.getWrappedConnection(this.proxyConnection);
                result = ProxyFactory.getDatabaseMetaData(this.proxyConnection.getConnection().getMetaData(), connection);
            } else if (concreteMethod.getName().equals(FINALIZE_METHOD)) {
                super.finalize();
            } else if (concreteMethod.getName().equals(TO_STRING_METHOD)) {
                result = this.toString();
            } else {
                if (this.proxyConnection == null) throw new SQLException("You can't perform a " + concreteMethod.getName() + " operation after the connection has been closed");
                if (concreteMethod.getName().startsWith("set")) {
                    this.proxyConnection.setNeedToReset(true);
                }
                try {
                    result = concreteMethod.invoke((Object)this.proxyConnection.getConnection(), args);
                }
                catch (IllegalAccessException e) {
                    LOG.debug("Ignoring IllegalAccessException whilst invoking the " + concreteMethod + " concrete method and trying the " + method + " method directly.");
                    InvokerFacade.overrideConcreteMethod(this.proxyConnection.getConnection().getClass(), method, method);
                    result = method.invoke((Object)this.proxyConnection.getConnection(), args);
                }
            }
            if (!(result instanceof Statement)) return result;
            String sqlStatement = null;
            if (argCount > 0 && args[0] instanceof String) {
                sqlStatement = (String)args[0];
            }
            this.proxyConnection.addOpenStatement((Statement)result);
            return ProxyFactory.getStatement((Statement)result, this.proxyConnection.getConnectionPool(), this.proxyConnection, sqlStatement);
        }
        catch (InvocationTargetException e) {
            if (!FatalSqlExceptionHelper.testException(this.proxyConnection.getDefinition(), e.getTargetException())) throw e.getTargetException();
            FatalSqlExceptionHelper.throwFatalSQLException(this.proxyConnection.getDefinition().getFatalSqlExceptionWrapper(), e.getTargetException());
            throw e.getTargetException();
        }
        catch (SQLException e) {
            throw new SQLException("Couldn't perform the operation " + concreteMethod.getName() + ": " + e.getMessage());
        }
        catch (Exception e) {
            LOG.error("Unexpected invocation exception", (Throwable)e);
            if (!FatalSqlExceptionHelper.testException(this.proxyConnection.getDefinition(), e)) throw new RuntimeException("Unexpected invocation exception: " + e.getMessage());
            FatalSqlExceptionHelper.throwFatalSQLException(this.proxyConnection.getDefinition().getFatalSqlExceptionWrapper(), e);
            throw new RuntimeException("Unexpected invocation exception: " + e.getMessage());
        }
    }

    public long getId() {
        return this.id;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Connection) {
            WrappedConnection wc = ProxyFactory.getWrappedConnection((Connection)obj);
            if (wc != null && wc.getId() > 0L && this.getId() > 0L) {
                return wc.getId() == this.getId();
            }
            return false;
        }
        return false;
    }

    public String toString() {
        if (this.proxyConnection != null) {
            return this.hashCode() + "(" + this.proxyConnection.getConnection().toString() + ")";
        }
        return this.hashCode() + "(out of scope)";
    }
}

