/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShutdownHook
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownHook.class);
    private static boolean registered;

    protected static void init() {
        if (!registered) {
            registered = true;
            new ShutdownHook();
        }
    }

    protected static void remove(Thread t) {
        block6: {
            Runtime runtime = Runtime.getRuntime();
            try {
                Method removeShutdownHookMethod = Runtime.class.getMethod("removeShutdownHook", Thread.class);
                removeShutdownHookMethod.invoke((Object)runtime, t);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removed shutdownHook");
                }
            }
            catch (NoSuchMethodException e) {
                LOG.warn("Proxool will have to be shutdown manually with ProxoolFacade.shutdown() because this version of the JDK does not support Runtime.getRuntime().addShutdownHook()");
            }
            catch (SecurityException e) {
                LOG.error("Problem removing shutdownHook", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error("Problem removing shutdownHook", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause instanceof IllegalStateException) break block6;
                LOG.error("Problem removing shutdownHook", (Throwable)e);
            }
        }
    }

    private ShutdownHook() {
        Thread t = new Thread(this);
        t.setName("ShutdownHook");
        Runtime runtime = Runtime.getRuntime();
        try {
            Method addShutdownHookMethod = Runtime.class.getMethod("addShutdownHook", Thread.class);
            addShutdownHookMethod.invoke((Object)runtime, t);
            ProxoolFacade.setShutdownHook(t);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registered shutdownHook");
            }
        }
        catch (NoSuchMethodException e) {
            LOG.warn("Proxool will have to be shutdown manually with ProxoolFacade.shutdown() because this version of the JDK does not support Runtime.getRuntime().addShutdownHook()");
        }
        catch (SecurityException e) {
            LOG.error("Problem registering shutdownHook", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Problem registering shutdownHook", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error("Problem registering shutdownHook", (Throwable)e);
        }
    }

    @Override
    public void run() {
        if (ProxoolFacade.isShutdownHookEnabled()) {
            LOG.debug("Running ShutdownHook");
            Thread.currentThread().setName("Shutdown Hook");
            ProxoolFacade.shutdown(0);
        } else {
            LOG.debug("Skipping ShutdownHook because it's been disabled");
        }
    }
}

