/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Statement;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.logicalcobwebs.proxool.AbstractProxyStatement;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.FatalSqlExceptionHelper;
import org.logicalcobwebs.proxool.ProxyConnectionIF;
import org.logicalcobwebs.proxool.proxy.InvokerFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProxyStatement
extends AbstractProxyStatement
implements MethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyStatement.class);
    private static final String EXECUTE_FRAGMENT = "execute";
    private static final String EXECUTE_BATCH_METHOD = "executeBatch";
    private static final String ADD_BATCH_METHOD = "addBatch";
    private static final String EQUALS_METHOD = "equals";
    private static final String CLOSE_METHOD = "close";
    private static final String GET_CONNECTION_METHOD = "getConnection";
    private static final String FINALIZE_METHOD = "finalize";
    private static final String SET_NULL_METHOD = "setNull";
    private static final String SET_PREFIX = "set";

    public ProxyStatement(Statement statement, ConnectionPool connectionPool, ProxyConnectionIF proxyConnection, String sqlStatement) {
        super(statement, connectionPool, proxyConnection, sqlStatement);
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        return this.invoke(proxy, method, args);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        block31: {
            result = null;
            long startTime = System.currentTimeMillis();
            int argCount = args != null ? args.length : 0;
            Method concreteMethod = InvokerFacade.getConcreteMethod(this.getStatement().getClass(), method);
            if (concreteMethod.getName().equals(ADD_BATCH_METHOD)) {
                if (argCount > 0 && args[0] instanceof String) {
                    this.setSqlStatementIfNull((String)args[0]);
                }
                this.appendToSqlLog();
            } else if (concreteMethod.getName().equals(EXECUTE_BATCH_METHOD)) {
                this.startExecute();
            } else if (concreteMethod.getName().startsWith(EXECUTE_FRAGMENT)) {
                if (argCount > 0 && args[0] instanceof String) {
                    this.setSqlStatementIfNull((String)args[0]);
                }
                this.appendToSqlLog();
                this.startExecute();
            }
            Exception exception = null;
            try {
                if (concreteMethod.getName().equals(EQUALS_METHOD) && argCount == 1) {
                    result = this.equals(args[0]) ? Boolean.TRUE : Boolean.FALSE;
                } else if (concreteMethod.getName().equals(CLOSE_METHOD) && argCount == 0) {
                    this.close();
                } else if (concreteMethod.getName().equals(GET_CONNECTION_METHOD) && argCount == 0) {
                    result = this.getConnection();
                } else if (concreteMethod.getName().equals(FINALIZE_METHOD) && argCount == 0) {
                    this.finalize();
                } else {
                    try {
                        result = concreteMethod.invoke((Object)this.getStatement(), args);
                    }
                    catch (IllegalAccessException e) {
                        LOG.debug("Ignoring IllegalAccessException whilst invoking the " + concreteMethod + " concrete method and trying the " + method + " method directly.");
                        InvokerFacade.overrideConcreteMethod(this.getStatement().getClass(), method, method);
                        result = method.invoke((Object)this.getStatement(), args);
                    }
                }
                if (!this.isTrace()) break block31;
                try {
                    if (concreteMethod.getName().equals(SET_NULL_METHOD) && argCount > 0 && args[0] instanceof Integer) {
                        int index = (Integer)args[0];
                        this.putParameter(index, null);
                    } else if (concreteMethod.getName().startsWith(SET_PREFIX) && argCount > 1 && args[0] instanceof Integer) {
                        int index = (Integer)args[0];
                        this.putParameter(index, args[1]);
                    }
                }
                catch (Exception e) {
                    LOG.error("Ignoring error during dump", (Throwable)e);
                }
            }
            catch (InvocationTargetException e) {
                exception = e.getTargetException() instanceof Exception ? (Exception)e.getTargetException() : e;
                if (this.testException(e.getTargetException())) {
                    FatalSqlExceptionHelper.throwFatalSQLException(this.getConnectionPool().getDefinition().getFatalSqlExceptionWrapper(), e.getTargetException());
                }
                throw e.getTargetException();
            }
            catch (Exception e) {
                exception = e;
                if (this.testException(e)) {
                    FatalSqlExceptionHelper.throwFatalSQLException(this.getConnectionPool().getDefinition().getFatalSqlExceptionWrapper(), e);
                }
                throw e;
            }
            finally {
                if (concreteMethod.getName().equals(EXECUTE_BATCH_METHOD) || concreteMethod.getName().startsWith(EXECUTE_FRAGMENT)) {
                    this.trace(startTime, exception);
                }
            }
        }
        return result;
    }
}

