/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolManager;
import org.logicalcobwebs.proxool.PrototyperThread;
import org.logicalcobwebs.proxool.ProxoolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrototyperController {
    private static final Logger LOG = LoggerFactory.getLogger(PrototyperController.class);
    private static PrototyperThread prototyperThread;
    private static boolean keepSweeping;
    private static final String LOCK = "LOCK";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void startPrototyper() {
        if (prototyperThread != null) return;
        String string = LOCK;
        synchronized (LOCK) {
            if (prototyperThread != null) return;
            prototyperThread = new PrototyperThread("Prototyper");
            prototyperThread.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    protected static void triggerSweep(String alias) {
        block13: {
            block12: {
                try {
                    ConnectionPool cp = ConnectionPoolManager.getInstance().getConnectionPool(alias);
                    try {
                        cp.acquirePrimaryReadLock();
                        cp.getPrototyper().triggerSweep();
                    }
                    catch (InterruptedException e) {
                        LOG.error("Couldn't acquire primary read lock", (Throwable)e);
                    }
                    finally {
                        cp.releasePrimaryReadLock();
                    }
                }
                catch (ProxoolException e) {
                    if (!LOG.isDebugEnabled()) break block12;
                    LOG.debug("Couldn't trigger prototyper triggerSweep for '" + alias + "'  - maybe it's just been shutdown");
                }
            }
            PrototyperController.startPrototyper();
            try {
                keepSweeping = true;
                if (prototyperThread != null) {
                    prototyperThread.doNotify();
                }
            }
            catch (IllegalMonitorStateException e) {
                LOG.debug("Hmm", (Throwable)e);
                if (Thread.activeCount() > 10 && LOG.isInfoEnabled()) {
                    LOG.info("Suspicious thread count of " + Thread.activeCount());
                }
            }
            catch (IllegalThreadStateException e) {
                if (!LOG.isDebugEnabled()) break block13;
                LOG.debug("Ignoring attempt to prototype whilst already prototyping");
            }
        }
    }

    public static boolean isKeepSweeping() {
        return keepSweeping;
    }

    public static void sweepStarted() {
        keepSweeping = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void shutdown() {
        String string = LOCK;
        synchronized (LOCK) {
            if (prototyperThread != null) {
                LOG.info("Stopping " + prototyperThread.getName() + " thread");
                prototyperThread.cancel();
                prototyperThread = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

