/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import org.logicalcobwebs.proxool.HouseKeeper;
import org.logicalcobwebs.proxool.HouseKeeperController;
import org.logicalcobwebs.proxool.ProxoolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HouseKeeperThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(HouseKeeperThread.class);
    private boolean stop;

    public HouseKeeperThread(String name) {
        this.setDaemon(true);
        this.setName(name);
    }

    @Override
    public void run() {
        while (!this.stop) {
            HouseKeeper hk = HouseKeeperController.getHouseKeeperToRun();
            while (hk != null && !this.stop) {
                try {
                    hk.sweep();
                }
                catch (ProxoolException e) {
                    LOG.error("Couldn't sweep " + hk.getAlias(), (Throwable)e);
                }
                hk = HouseKeeperController.getHouseKeeperToRun();
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted", (Throwable)e);
            }
        }
    }

    protected void cancel() {
        this.stop = true;
    }
}

