/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Connection;
import java.sql.Statement;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolDefinition;
import org.logicalcobwebs.proxool.FormatHelper;
import org.logicalcobwebs.proxool.PrototyperController;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxyConnectionIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HouseKeeper {
    private static final Logger LOG = LoggerFactory.getLogger(HouseKeeper.class);
    private ConnectionPool connectionPool;
    private long timeLastSwept;

    public HouseKeeper(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sweep() throws ProxoolException {
        ConnectionPoolDefinition definition = this.connectionPool.getDefinition();
        Logger log = this.connectionPool.getLog();
        Statement testStatement = null;
        try {
            this.connectionPool.acquirePrimaryReadLock();
            Connection connection = null;
            ProxyConnectionIF proxyConnection = null;
            int recentlyStartedActiveConnectionCountTemp = 0;
            int[] verifiedConnectionCountByState = new int[4];
            ProxyConnectionIF[] proxyConnections = this.connectionPool.getProxyConnections();
            for (int i = 0; i < proxyConnections.length; ++i) {
                proxyConnection = proxyConnections[i];
                connection = proxyConnection.getConnection();
                if (!this.connectionPool.isConnectionPoolUp()) break;
                if (proxyConnection.setStatus(1, 3)) {
                    try {
                        String sql;
                        testStatement = connection.createStatement();
                        if (proxyConnection.isReallyClosed()) {
                            proxyConnection.setStatus(3, 0);
                            this.connectionPool.removeProxyConnection(proxyConnection, 6, "it appears to be closed", true, true);
                        }
                        if ((sql = definition.getHouseKeepingTestSql()) != null && sql.length() > 0) {
                            boolean testResult = false;
                            try {
                                testResult = testStatement.execute(sql);
                            }
                            catch (Throwable throwable) {
                                if (log.isDebugEnabled() && definition.isVerbose()) {
                                    log.debug(this.connectionPool.displayStatistics() + " - Testing connection " + proxyConnection.getId() + (testResult ? ": True" : ": False"));
                                }
                                throw throwable;
                            }
                            if (log.isDebugEnabled() && definition.isVerbose()) {
                                log.debug(this.connectionPool.displayStatistics() + " - Testing connection " + proxyConnection.getId() + (testResult ? ": True" : ": False"));
                            }
                        }
                        proxyConnection.setStatus(3, 1);
                    }
                    catch (Throwable e) {
                        proxyConnection.setStatus(3, 0);
                        this.connectionPool.removeProxyConnection(proxyConnection, 6, "it has problems: " + e, false, true);
                    }
                    finally {
                        try {
                            testStatement.close();
                        }
                        catch (Throwable sql) {}
                    }
                }
                if (proxyConnection.getAge() > definition.getMaximumConnectionLifetime()) {
                    String reason = "age is " + proxyConnection.getAge() + "ms";
                    if (proxyConnection.setStatus(1, 3)) {
                        if (proxyConnection.setStatus(3, 0)) {
                            this.connectionPool.expireProxyConnection(proxyConnection, 7, reason, false);
                        }
                    } else {
                        proxyConnection.markForExpiry(reason);
                        if (log.isDebugEnabled()) {
                            log.debug(this.connectionPool.displayStatistics() + " - #" + FormatHelper.formatMediumNumber(proxyConnection.getId()) + " marked for expiry.");
                        }
                    }
                }
                if (proxyConnection.isActive()) {
                    long activeTime = System.currentTimeMillis() - proxyConnection.getTimeLastStartActive();
                    if (activeTime < definition.getRecentlyStartedThreshold()) {
                        ++recentlyStartedActiveConnectionCountTemp;
                    }
                    if (activeTime > definition.getMaximumActiveTime()) {
                        this.connectionPool.removeProxyConnection(proxyConnection, 1, "it has been active for too long", true, true);
                        String lastSqlCallMsg = proxyConnection.getLastSqlCall() != null ? ", and the last SQL it performed is '" + proxyConnection.getLastSqlCall() + "'." : (!proxyConnection.getDefinition().isTrace() ? ", but the last SQL it performed is unknown because the trace property is not enabled." : ", but the last SQL it performed is unknown.");
                        log.warn("#" + FormatHelper.formatMediumNumber(proxyConnection.getId()) + " was active for " + activeTime + " milliseconds and has been removed automaticaly. The Thread responsible was named '" + proxyConnection.getRequester() + "'" + lastSqlCallMsg);
                    }
                }
                int n = proxyConnection.getStatus();
                verifiedConnectionCountByState[n] = verifiedConnectionCountByState[n] + 1;
            }
            this.calculateUpState(recentlyStartedActiveConnectionCountTemp);
        }
        catch (Throwable e) {
            log.error("Housekeeping log.error( :", e);
        }
        finally {
            this.connectionPool.releasePrimaryReadLock();
            this.timeLastSwept = System.currentTimeMillis();
            if (definition.isVerbose() && log.isDebugEnabled()) {
                log.debug(this.connectionPool.displayStatistics() + " - House keeping triggerSweep done");
            }
        }
        PrototyperController.triggerSweep(definition.getAlias());
    }

    private long getTimeSinceLastSweep() {
        return System.currentTimeMillis() - this.timeLastSwept;
    }

    protected boolean isSweepDue() {
        if (this.connectionPool.isConnectionPoolUp()) {
            return this.getTimeSinceLastSweep() > this.connectionPool.getDefinition().getHouseKeepingSleepTime();
        }
        LOG.warn("House keeper is still being asked to sweep despite the connection pool being down");
        return false;
    }

    private void calculateUpState(int recentlyStartedActiveConnectionCount) {
        try {
            int calculatedUpState = 0;
            int availableConnectionCount = this.connectionPool.getAvailableConnectionCount();
            if (availableConnectionCount > 0 || recentlyStartedActiveConnectionCount > 0) {
                if (this.connectionPool.getTimeOfLastRefusal() > System.currentTimeMillis() - this.connectionPool.getDefinition().getOverloadWithoutRefusalLifetime()) {
                    calculatedUpState = 2;
                } else if (this.connectionPool.getActiveConnectionCount() > 0) {
                    calculatedUpState = 1;
                }
            } else {
                calculatedUpState = 3;
            }
            this.connectionPool.setUpState(calculatedUpState);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    protected String getAlias() {
        return this.connectionPool.getDefinition().getAlias();
    }
}

