/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Connection;
import java.sql.Statement;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ConnectionValidatorIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectionValidator
implements ConnectionValidatorIF {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate(ConnectionPoolDefinitionIF cpd, Connection connection) {
        String testSql = cpd.getHouseKeepingTestSql();
        if (testSql == null || testSql.length() == 0) {
            Logger log = this.getPoolLog(cpd.getAlias());
            log.warn("Connection validation requested but house-keeping-test-sql not defined");
            return false;
        }
        Statement st = null;
        try {
            st = connection.createStatement();
            st.execute(testSql);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            Logger log = this.getPoolLog(cpd.getAlias());
            if (log.isDebugEnabled()) {
                log.debug("A connection failed the validation test with error: " + t);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Throwable t) {
                    return false;
                }
            }
        }
    }

    private Logger getPoolLog(String poolAlias) {
        return LoggerFactory.getLogger((String)("org.logicalcobwebs.proxool." + poolAlias));
    }
}

