/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.util.Properties;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ProxoolListenerIF;
import org.logicalcobwebs.proxool.util.AbstractListenerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeProxoolListener
extends AbstractListenerContainer
implements ProxoolListenerIF {
    static final Logger LOG = LoggerFactory.getLogger(CompositeProxoolListener.class);

    @Override
    public void onRegistration(ConnectionPoolDefinitionIF connectionPoolDefinition, Properties completeInfo) {
        Object[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                ProxoolListenerIF proxoolListener = (ProxoolListenerIF)listeners[i];
                proxoolListener.onRegistration(connectionPoolDefinition, (Properties)completeInfo.clone());
                continue;
            }
            catch (RuntimeException re) {
                LOG.warn("RuntimeException received from listener " + listeners[i] + " when dispatching onRegistration event", (Throwable)re);
            }
        }
    }

    @Override
    public void onShutdown(String alias) {
        Object[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                ProxoolListenerIF proxoolListener = (ProxoolListenerIF)listeners[i];
                proxoolListener.onShutdown(alias);
                continue;
            }
            catch (RuntimeException re) {
                LOG.warn("RuntimeException received from listener " + listeners[i] + " when dispatching onShutdown event", (Throwable)re);
            }
        }
    }
}

