/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Connection;
import java.sql.SQLException;
import org.logicalcobwebs.proxool.ConnectionListenerIF;
import org.logicalcobwebs.proxool.util.AbstractListenerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeConnectionListener
extends AbstractListenerContainer
implements ConnectionListenerIF {
    static final Logger LOG = LoggerFactory.getLogger(CompositeConnectionListener.class);

    @Override
    public void onBirth(Connection connection) throws SQLException {
        Object[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                ConnectionListenerIF connectionListener = (ConnectionListenerIF)listeners[i];
                connectionListener.onBirth(connection);
                continue;
            }
            catch (RuntimeException re) {
                LOG.warn("RuntimeException received from listener " + listeners[i] + " when dispatching onBirth event", (Throwable)re);
                continue;
            }
            catch (SQLException se) {
                LOG.warn("SQLException received from listener " + listeners[i] + " when dispatching onBirth event - event dispatching cancelled");
                throw se;
            }
        }
    }

    @Override
    public void onDeath(Connection connection, int reasonCode) throws SQLException {
        Object[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                ConnectionListenerIF connectionListener = (ConnectionListenerIF)listeners[i];
                connectionListener.onDeath(connection, reasonCode);
                continue;
            }
            catch (RuntimeException re) {
                LOG.warn("RuntimeException received from listener " + listeners[i] + " when dispatching onDeath event", (Throwable)re);
                continue;
            }
            catch (SQLException se) {
                LOG.warn("SQLException received from listener " + listeners[i] + " when dispatching onDeath event - event dispatching cancelled");
                throw se;
            }
        }
    }

    @Override
    public void onExecute(String command, long elapsedTime) {
        Object[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                ConnectionListenerIF connectionListener = (ConnectionListenerIF)listeners[i];
                connectionListener.onExecute(command, elapsedTime);
                continue;
            }
            catch (RuntimeException re) {
                LOG.warn("RuntimeException received from listener " + listeners[i] + " when dispatching onExecute event", (Throwable)re);
            }
        }
    }

    @Override
    public void onFail(String command, Exception exception) {
        Object[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                ConnectionListenerIF connectionListener = (ConnectionListenerIF)listeners[i];
                connectionListener.onFail(command, exception);
                continue;
            }
            catch (RuntimeException re) {
                LOG.warn("RuntimeException received from listener " + listeners[i] + " when dispatching onFail event", (Throwable)re);
            }
        }
    }
}

