/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.plugin;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import net.isger.brick.core.BaseCommand;
import net.isger.brick.core.Command;
import net.isger.brick.core.CoreHelper;
import net.isger.brick.plugin.Plugin;
import net.isger.brick.plugin.PluginCommand;
import net.isger.brick.plugin.service.Service;
import net.isger.brick.plugin.service.Services;
import net.isger.util.Helpers;
import net.isger.util.Strings;
import net.isger.util.reflect.BoundMethod;
import net.isger.util.reflect.Standin;
import net.isger.util.sql.Pager;

public class PluginHelper
extends CoreHelper {
    protected PluginHelper() {
    }

    public static Plugin getPlugin() {
        return (Plugin)CoreHelper.getGate();
    }

    public static Object toService() {
        return PluginHelper.toService(PluginCommand.getAction());
    }

    public static Object toService(PluginCommand cmd) {
        PluginHelper.getPlugin().service(cmd);
        return cmd.getResult();
    }

    public static Object toService(PluginCommand cmd, String name) {
        if (Strings.isNotEmpty((Object)name)) {
            cmd.setName(name);
        }
        return PluginHelper.toService(cmd);
    }

    public static Object toService(PluginCommand cmd, Class<? extends Service> clazz) {
        return PluginHelper.toService(cmd, Services.getName(clazz));
    }

    public static Object toService(PluginCommand cmd, String name, String operate) {
        cmd.setOperate(operate);
        return PluginHelper.toService(cmd, name);
    }

    public static Object toService(PluginCommand cmd, Class<? extends Service> clazz, String operate) {
        return PluginHelper.toService(cmd, Services.getName(clazz), operate);
    }

    public static Object toPersist() {
        return PluginHelper.toPersist(PluginCommand.getAction());
    }

    public static Object toPersist(PluginCommand cmd) {
        Object value = cmd.getParameter("common.statement.value");
        if (value != null && !(value instanceof Object[])) {
            cmd.setParameter("common.statement.value", Helpers.wraps((Object[])new Object[]{value}));
        }
        PluginHelper.getPlugin().persist(cmd);
        return cmd.getResult();
    }

    public static Object toPersist(PluginCommand cmd, String operate) {
        cmd.setOperate(operate);
        return PluginHelper.toPersist(cmd);
    }

    public static Object toPersist(PluginCommand cmd, String operate, String persist) {
        cmd.setPersist(persist);
        return PluginHelper.toPersist(cmd, operate);
    }

    public static Object toPersist(PluginCommand cmd, String operate, String persist, String statement) {
        cmd.setParameter("common.statement.id", statement);
        return PluginHelper.toPersist(cmd, operate, persist);
    }

    public static Object toPersist(PluginCommand cmd, String operate, String persist, String statement, Object value) {
        cmd.setParameter("common.statement.value", value);
        return PluginHelper.toPersist(cmd, operate, persist, statement);
    }

    public static Object toPersists(PluginCommand cmd, String operate, String persist, String statement, Object value, Object ... args) {
        cmd.setParameter("common.statement.args", args);
        return PluginHelper.toPersist(cmd, operate, persist, statement, value);
    }

    public static <T> T service(Class<T> clazz) {
        return PluginHelper.service(null, clazz, null, null);
    }

    public static <T> T service(Class<T> clazz, String domain) {
        return PluginHelper.service(null, clazz, domain, null);
    }

    public static <T> T service(PluginCommand cmd, Class<T> clazz) {
        return PluginHelper.service(cmd, clazz, null, null);
    }

    public static <T> T service(PluginCommand cmd, Class<T> clazz, String domain) {
        return PluginHelper.service(cmd, clazz, domain, null);
    }

    public static <T> T service(PluginCommand cmd, final Class<T> clazz, final String domain, final String name) {
        if (cmd == null) {
            cmd = PluginCommand.getAction().clone();
        }
        final PluginCommand shellCmd = new PluginCommand((Command)cmd);
        return (T)new Standin<T>(clazz){

            public Object action(Method method, Object[] args) {
                String[] serviceName = Services.getName(clazz).split("[:]");
                if (Strings.isNotEmpty((Object)domain)) {
                    shellCmd.setDomain(domain);
                } else if (serviceName.length > 1) {
                    shellCmd.setDomain(serviceName[0]);
                }
                shellCmd.setName(Strings.isEmpty((Object)name) ? (serviceName.length > 1 ? serviceName[1] : serviceName[0]) : name);
                String operate = BoundMethod.makeMethodDesc((Method)method);
                shellCmd.setOperate(operate);
                Class<?>[] paramTypes = method.getParameterTypes();
                Annotation[][] annos = method.getParameterAnnotations();
                int size = paramTypes.length;
                for (int i = 0; i < size; ++i) {
                    String paramName = Helpers.getAliasName((Annotation[])annos[i]);
                    if (Strings.isEmpty((Object)paramName)) {
                        paramName = operate + i;
                    }
                    shellCmd.setParameter(paramName, args[i]);
                }
                return PluginHelper.toConsole((BaseCommand)shellCmd);
            }
        }.getSource();
    }

    public static void enablePage(BaseCommand cmd, boolean enabled) {
        cmd.setParameter((CharSequence)"common.page", enabled ? cmd.getParameter(Pager.class) : null);
    }

    public static boolean enabledPage(BaseCommand cmd) {
        return cmd.getParameter((CharSequence)"common.page") instanceof Pager;
    }
}

