/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.handler.codec.DatagramPacketDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.AttributeKey;
import java.io.InputStream;
import java.util.List;
import net.isger.brick.auth.AuthCommand;
import net.isger.brick.auth.AuthHelper;
import net.isger.brick.auth.AuthIdentity;
import net.isger.brick.auth.BaseToken;
import net.isger.brick.bus.Bus;
import net.isger.brick.bus.Endpoint;
import net.isger.brick.bus.SocketEndpoint;
import net.isger.brick.core.Command;
import net.isger.brick.core.Console;
import net.isger.util.Helpers;
import net.isger.util.anno.Alias;
import net.isger.util.anno.Ignore;

@Ignore
public abstract class NettyEndpoint
extends SocketEndpoint {
    private static final AttributeKey<AuthIdentity> ATTR_IDENTITY = AttributeKey.valueOf((String)"brick.bus.netty.channel.identity");
    private static final AttributeKey<Boolean> ATTR_IDENTITY_LOCAL = AttributeKey.valueOf((String)"brick.bus.netty.channel.identity.local");
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="system")
    protected Console console;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="system")
    private Bus bus;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private boolean createable;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private Integer timeout;

    public NettyEndpoint() {
    }

    public NettyEndpoint(String host, int port) {
        super(host, port);
    }

    protected void open() {
        super.open();
        NettyEncoder encoder = new NettyEncoder();
        NettyDecoder pendingDecoder = new NettyDecoder();
        NettyDecoder decoder = "tcp".equalsIgnoreCase(this.getChannel()) ? pendingDecoder : new DatagramPacketDecoder((MessageToMessageDecoder)pendingDecoder);
        NettyHandler handler = new NettyHandler();
        this.bootstrap(new ChannelInitializer<Channel>((ChannelInboundHandler)decoder, (ChannelOutboundHandler)encoder, (ChannelInboundHandler)handler){
            final /* synthetic */ ChannelInboundHandler val$decoder;
            final /* synthetic */ ChannelOutboundHandler val$encoder;
            final /* synthetic */ ChannelInboundHandler val$handler;
            {
                this.val$decoder = channelInboundHandler;
                this.val$encoder = channelOutboundHandler;
                this.val$handler = channelInboundHandler2;
            }

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{this.val$decoder, this.val$encoder, this.val$handler});
            }
        });
        this.toActive();
    }

    protected abstract void bootstrap(ChannelInitializer<Channel> var1);

    protected Object receive(AuthIdentity identity, Object message) {
        return this.getHandler().handle((Endpoint)this, identity, message);
    }

    protected void send(ChannelHandlerContext context, Object message) {
        context.channel().writeAndFlush(message);
    }

    protected AuthIdentity getIdentity(ChannelHandlerContext context) {
        return (AuthIdentity)context.channel().attr(ATTR_IDENTITY).get();
    }

    protected void setIdentity(ChannelHandlerContext context, AuthIdentity identity) {
        context.channel().attr(ATTR_IDENTITY).setIfAbsent((Object)identity);
    }

    protected void close() {
        super.close();
    }

    @ChannelHandler.Sharable
    private class NettyHandler
    extends ChannelInboundHandlerAdapter {
        private NettyHandler() {
        }

        public void channelActive(ChannelHandlerContext context) throws Exception {
            super.channelActive(context);
            if (NettyEndpoint.this.getIdentity(context) == null) {
                AuthCommand cmd = AuthHelper.makeCommand((String)"system", (Object)new BaseToken((Object)context, (Object)context));
                cmd.setOperate("login");
                NettyEndpoint.this.console.execute((Command)cmd);
                NettyEndpoint.this.setIdentity(context, cmd.getIdentity());
                context.channel().attr(ATTR_IDENTITY_LOCAL).set((Object)true);
            }
        }

        public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
            AuthIdentity identity = NettyEndpoint.this.getIdentity(context);
            identity.active(NettyEndpoint.this.createable);
            message = NettyEndpoint.this.receive(identity, message);
            if (message != null) {
                NettyEndpoint.this.send(context, message);
            }
        }

        public void channelInactive(ChannelHandlerContext context) throws Exception {
            AuthIdentity identity;
            if (Helpers.toBoolean((Object)context.channel().attr(ATTR_IDENTITY_LOCAL).get()) && (identity = NettyEndpoint.this.getIdentity(context)) != null) {
                AuthCommand cmd = AuthHelper.makeCommand((String)"system", (Object)identity.getToken());
                cmd.setIdentity(identity);
                cmd.setOperate("logout");
                NettyEndpoint.this.console.execute((Command)cmd);
            }
            super.channelInactive(context);
        }
    }

    @ChannelHandler.Sharable
    private class NettyDecoder
    extends MessageToMessageDecoder<ByteBuf> {
        private NettyDecoder() {
        }

        protected void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) throws Exception {
            Object message = NettyEndpoint.this.getProtocol().getDecoder().decode((InputStream)new ByteBufInputStream(in));
            if (message != null) {
                out.add(message);
            }
        }
    }

    @ChannelHandler.Sharable
    private class NettyEncoder
    extends MessageToByteEncoder<Object> {
        private NettyEncoder() {
        }

        protected void encode(ChannelHandlerContext context, Object message, ByteBuf out) throws Exception {
            byte[] value = NettyEndpoint.this.getProtocol().getEncoder().encode(message);
            if (value != null) {
                out.writeBytes(value);
            }
        }
    }
}

