/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus;

import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.isger.brick.auth.AuthCommand;
import net.isger.brick.auth.AuthHelper;
import net.isger.brick.auth.AuthIdentity;
import net.isger.brick.auth.BaseToken;
import net.isger.brick.bus.Endpoint;
import net.isger.brick.bus.SocketEndpoint;
import net.isger.brick.core.Command;
import net.isger.brick.core.Console;
import net.isger.brick.core.CoreHelper;
import net.isger.util.anno.Ignore;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public abstract class MinaEndpoint
extends SocketEndpoint {
    private static final byte[] MAGIC = "BRICK".getBytes();
    private static final int DATA_MIN_LIMIT = MAGIC.length + 4;
    private static final String ATTR_IDENTITY = "brick.bus.identity";
    private static final Logger LOG = LoggerFactory.getLogger(MinaEndpoint.class);
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private boolean createable;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private int timeout;
    private transient ExecutorService executor = Executors.newCachedThreadPool();
    private transient IoService service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open() {
        MinaEndpoint minaEndpoint = this;
        synchronized (minaEndpoint) {
            if (this.service != null) {
                return;
            }
            super.open();
            this.service = this.createService();
        }
        this.timeout = (int)TimeUnit.MINUTES.toMillis(Math.max(this.timeout, 5));
        final ProtocolEncoder encoder = this.createEncoder();
        final ProtocolDecoder decoder = this.createDecoder();
        DefaultIoFilterChainBuilder filterChain = this.service.getFilterChain();
        filterChain.addLast(this.getProtocolName(), (IoFilter)new ProtocolCodecFilter(new ProtocolCodecFactory(){

            public ProtocolEncoder getEncoder(IoSession session) throws Exception {
                return encoder;
            }

            public ProtocolDecoder getDecoder(IoSession session) throws Exception {
                return decoder;
            }
        }));
        this.service.setHandler((IoHandler)new IoHandlerAdapter(){

            public void sessionOpened(IoSession session) throws Exception {
                block3: {
                    AuthIdentity identity = MinaEndpoint.this.getIdentity(session);
                    if (identity != null) {
                        LOG.info("Session [{}] opened of [{}]", (Object)session.getId(), identity.getToken().getPrincipal());
                        try {
                            MinaEndpoint.this.getHandler().open((Endpoint)MinaEndpoint.this, identity);
                            return;
                        }
                        catch (Throwable cause) {
                            if (!LOG.isDebugEnabled()) break block3;
                            LOG.warn("(!) Session [{}] open post-processing failed", (Object)session.getId(), (Object)cause);
                        }
                    }
                }
                session.closeNow();
            }

            public void messageReceived(IoSession session, Object message) throws Exception {
                AuthIdentity identity = MinaEndpoint.this.getIdentity(session);
                if (identity != null) {
                    LOG.debug("Session [{}] received message: \r\n{}", (Object)session.getId(), message);
                    message = MinaEndpoint.this.getHandler().handle((Endpoint)MinaEndpoint.this, identity, message);
                    if (message != null) {
                        LOG.debug("Session [{}] response message: \r\n{}", (Object)session.getId(), message);
                        session.write(message);
                    }
                }
            }

            public void sessionClosed(final IoSession session) throws Exception {
                MinaEndpoint.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AuthIdentity identity = MinaEndpoint.this.getIdentity(session);
                            MinaEndpoint.this.getHandler().close((Endpoint)MinaEndpoint.this, identity);
                            AuthCommand cmd = AuthHelper.makeCommand((String)"system", (Object)identity.getToken());
                            cmd.setIdentity(identity);
                            cmd.setOperate("logout");
                            MinaEndpoint.this.console.execute((Command)cmd);
                        }
                        catch (Exception e) {
                            LOG.warn("(!) Disconnect session exception", (Throwable)e);
                        }
                        LOG.info("Session [{}] closed", (Object)session.getId());
                    }
                });
            }
        });
        this.toActive();
    }

    protected abstract IoService createService();

    protected ProtocolEncoder createEncoder() {
        return new ProtocolEncoderAdapter(){

            public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
                byte[] value = MinaEndpoint.this.getProtocol().getEncoder().encode(message);
                if (value != null && value.length > 0) {
                    IoBuffer buffer = IoBuffer.allocate((int)(value.length + DATA_MIN_LIMIT)).setAutoExpand(true);
                    buffer.put(MAGIC);
                    buffer.putInt(value.length);
                    buffer.put(value);
                    buffer.flip();
                    out.write((Object)buffer);
                    out.flush();
                }
            }
        };
    }

    protected ProtocolDecoder createDecoder() {
        return new CumulativeProtocolDecoder(){

            protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
                boolean result;
                in.mark();
                int size = MinaEndpoint.this.correct(in);
                if (size < 0) {
                    in.reset();
                    return false;
                }
                if (size == 0) {
                    in.mark();
                    return true;
                }
                byte[] content = new byte[size];
                in.get(content);
                Object message = MinaEndpoint.this.getProtocol().getDecoder().decode(content);
                boolean bl = result = message != null;
                if (result) {
                    out.write(message);
                }
                return result;
            }
        };
    }

    private int correct(IoBuffer in) {
        int index = 0;
        while (true) {
            if (in.remaining() < DATA_MIN_LIMIT - index) {
                return -1;
            }
            byte value = in.get();
            if (value == MAGIC[index++]) {
                if (index != MAGIC.length) continue;
                break;
            }
            in.mark();
            index = 0;
        }
        int size = in.getInt();
        return in.remaining() >= size ? size : -1;
    }

    protected IoService getService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthIdentity getIdentity(IoSession session) {
        CoreHelper.setConsole((Console)this.console);
        AuthIdentity identity = (AuthIdentity)session.getAttribute((Object)ATTR_IDENTITY);
        IoSession ioSession = session;
        synchronized (ioSession) {
            if (session.isConnected()) {
                String client = ((InetSocketAddress)session.getRemoteAddress()).getAddress().getHostAddress();
                if (identity == null) {
                    identity = AuthHelper.toLogin((String)"system", (Object)new BaseToken((Object)client, (Object)session)).getIdentity();
                    session.setAttribute((Object)ATTR_IDENTITY, (Object)identity);
                    session.getConfig().setBothIdleTime(this.timeout);
                    identity.setTimeout(this.timeout);
                    this.getHandler().reload((Endpoint)this, identity);
                } else {
                    try {
                        identity.active(this.createable);
                    }
                    catch (Exception e) {
                        LOG.warn("(!) Failure to active session identity, Need to regenerate session identity - {}", (Object)e.getMessage(), (Object)e.getCause());
                        try {
                            this.getHandler().unload((Endpoint)this, identity);
                        }
                        catch (Exception e2) {
                            LOG.warn("(!) Failure to unload session identity - {}", (Object)e2.getMessage(), (Object)e2.getCause());
                        }
                        session.removeAttribute((Object)ATTR_IDENTITY);
                        identity = this.getIdentity(session);
                    }
                }
            }
        }
        return identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        MinaEndpoint minaEndpoint = this;
        synchronized (minaEndpoint) {
            if (this.service != null) {
                this.service.dispose(true);
                this.service = null;
            }
        }
    }
}

