/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.auth;

import net.isger.brick.auth.AuthIdentity;
import net.isger.brick.auth.AuthToken;
import net.isger.brick.auth.ShiroToken;
import org.apache.shiro.session.ExpiredSessionException;
import org.apache.shiro.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroIdentity
extends AuthIdentity {
    private static final Logger LOG = LoggerFactory.getLogger(ShiroIdentity.class);

    public boolean isLogin() {
        return super.isLogin() && this.getToken().getSubject().isAuthenticated();
    }

    public void active(boolean create) {
        super.active(create);
        this.getToken().getSubject().getSession(create).touch();
    }

    public void setTimeout(int timeout) {
        this.getToken().getSubject().getSession().setTimeout((long)timeout);
    }

    public ShiroToken getToken() {
        return (ShiroToken)super.getToken();
    }

    public void setToken(AuthToken<?> token) {
        if (token != null && !(token instanceof ShiroToken)) {
            token = new ShiroToken(token);
        }
        super.setToken(token);
    }

    public Object getAttribute(String name) {
        try {
            return this.getToken().getSubject().getSession().getAttribute((Object)name);
        }
        catch (ExpiredSessionException e) {
            LOG.warn("(!) Failure to get attribute[{}] - {}", (Object)name, (Object)e.getMessage());
            return super.getAttribute(name);
        }
    }

    public void setAttribute(String name, Object value) {
        Session session = this.getToken().getSubject().getSession();
        if (value == null) {
            session.removeAttribute((Object)name);
        } else {
            session.setAttribute((Object)name, value);
        }
    }

    public void clear() {
        Session session = this.getToken().getSubject().getSession();
        for (Object name : session.getAttributeKeys()) {
            session.removeAttribute(name);
        }
        super.clear();
    }
}

