/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.stub;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import net.isger.brick.stub.SqlStub;
import net.isger.util.Helpers;
import net.isger.util.Strings;

public class PoolStub
extends SqlStub {
    private String name;

    public DataSource getDataSource() {
        DataSource dataSource = super.getDataSource();
        if (dataSource == null) {
            HikariConfig config;
            Properties props = new Properties();
            for (Map.Entry param : this.getParameters().entrySet()) {
                Object value;
                props.setProperty((String)param.getKey(), Strings.empty((value = param.getValue()) instanceof Number ? Integer.valueOf(((Number)value).intValue()) : value));
            }
            if (Strings.isEmpty((Object)this.name)) {
                config = new HikariConfig();
                config.addDataSourceProperty("cachePrepStmts", (Object)"true");
                config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
                config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
            } else {
                config = new HikariConfig(this.name.endsWith(".properties") ? this.name : this.name + ".properties");
            }
            config.setDataSourceProperties(props);
            config.setDriverClassName(this.getDriverName());
            config.setJdbcUrl(this.getUrl());
            config.setUsername(this.getUser());
            config.setPassword(this.getPassword());
            dataSource = new HikariDataSource(config);
        }
        return dataSource;
    }

    protected String getDriverName() {
        return (String)Helpers.coalesce((Object[])new String[]{super.getDriverName(), (String)this.getParameter("driver"), (String)this.getParameter("driverClass")});
    }

    protected String getUrl() {
        return (String)Helpers.coalesce((Object[])new String[]{super.getUrl(), (String)this.getParameter("jdbc"), (String)this.getParameter("jdbcUrl")});
    }

    protected String getUser() {
        return (String)Helpers.coalesce((Object[])new String[]{super.getUser(), (String)this.getParameter("username")});
    }
}

