/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.plugin.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.isger.brick.plugin.service.Service;
import net.isger.util.Helpers;
import net.isger.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Services {
    private static final Logger LOG = LoggerFactory.getLogger(Services.class);
    private Map<String, Service> services = new HashMap<String, Service>();

    public Services() {
        this(null);
    }

    public Services(List<Object> services) {
        if (services != null) {
            for (Object instance : services) {
                if (instance instanceof Service) {
                    this.add((Service)instance);
                    continue;
                }
                if (!(instance instanceof Map)) continue;
                for (Map.Entry entry : ((Map)instance).entrySet()) {
                    instance = entry.getValue();
                    if (!(instance instanceof Service)) continue;
                    this.put((String)entry.getKey(), (Service)instance);
                }
            }
        }
    }

    public void add(Service service) {
        this.put("", service);
    }

    public void put(String name, Service service) {
        String key;
        int index = name.lastIndexOf(".");
        if (index++ > 0) {
            key = name.substring(0, index);
            name = name.substring(index);
        } else {
            key = "";
        }
        key = key + Services.getName(service.getClass(), name);
        if (LOG.isDebugEnabled()) {
            LOG.info("Binding [{}] service [{}]", (Object)key, (Object)service);
        }
        if ((service = this.services.put(key, service)) != null) {
            LOG.warn("(!) Discard [{}] service [{}]", (Object)key, (Object)service);
        }
    }

    public Map<String, Service> gets() {
        return Collections.unmodifiableMap(this.services);
    }

    public Service get(String name) {
        return this.services.get(name);
    }

    public static final String getName(Class<?> clazz) {
        return Services.getName(clazz, "");
    }

    public static final String getName(Class<?> clazz, String name) {
        return Helpers.getAliasName(clazz, (String)"Service$", (String)Strings.toLower((String)name));
    }
}

