/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.plugin;

import net.isger.brick.core.BaseCommand;
import net.isger.brick.core.BaseGate;
import net.isger.brick.core.GateCommand;
import net.isger.brick.plugin.Plugin;
import net.isger.brick.plugin.PluginCommand;
import net.isger.brick.plugin.persist.Persist;
import net.isger.brick.plugin.service.Service;
import net.isger.brick.stub.StubCommand;
import net.isger.util.Asserts;
import net.isger.util.Strings;

public abstract class AbstractPlugin
extends BaseGate
implements Plugin {
    protected abstract Service getService(String var1);

    protected abstract Persist getPersist(String var1);

    public void operate(GateCommand cmd) {
        PluginCommand pcmd = (PluginCommand)cmd;
        if (Strings.isEmpty((Object)pcmd.getName())) {
            super.operate(cmd);
        } else {
            this.service(pcmd);
        }
    }

    @Override
    public void service(PluginCommand cmd) {
        String name = cmd.getName();
        Service service = this.getService(name);
        Asserts.isNotNull((Object)service, (String)"Unfound the specified service [%s] in the [%s] plugin [%s], Check whether it is configured in the brick configuration file", (Object[])new Object[]{name, cmd.getDomain(), this.getClass().getName()});
        service.service(cmd);
    }

    @Override
    public void persist(PluginCommand cmd) {
        String name = cmd.getName();
        Persist persist = this.getPersist(name);
        Asserts.isNotNull((Object)persist, (String)"Unfound the specified persist [%s] in the [%s] plugin [%s], Check whether it is configured in the brick configuration file", (Object[])new Object[]{name, cmd.getDomain(), this.getClass().getName()});
        persist.persist(StubCommand.cast((BaseCommand)cmd));
    }
}

