/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import net.isger.brick.auth.AuthIdentity;
import net.isger.brick.bus.BusCommand;
import net.isger.brick.bus.MinaEndpoint;
import net.isger.util.Helpers;
import net.isger.util.anno.Ignore;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaOutbound
extends MinaEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(MinaOutbound.class);
    @Ignore
    private Map<String, IoSession> sessions = new HashMap<String, IoSession>();

    @Override
    protected IoService createService() {
        return new NioSocketConnector();
    }

    protected IoSession getSession(BusCommand cmd) {
        AuthIdentity identity = cmd.getIdentity();
        String identityId = identity.getId();
        IoSession session = this.sessions.get(identityId);
        if (session == null || session.isClosing()) {
            InetSocketAddress address = this.getAddress();
            ConnectFuture future = ((SocketConnector)this.getService()).connect((SocketAddress)address);
            do {
                Helpers.sleep((long)100L);
                session = future.getSession();
                if (session == null) continue;
                LOG.info("Connected to [{}://{}]", (Object)this.getProtocolName(), (Object)address);
                this.sessions.put(identityId, session);
                break;
            } while (!Thread.interrupted());
        }
        return session;
    }

    public void send(BusCommand cmd) {
        Object payload = cmd.getPayload();
        if (payload != null) {
            this.getSession(cmd).write(payload);
        }
    }

    @Override
    protected void close() {
        for (IoSession session : this.sessions.values()) {
            if (session == null || !session.isConnected()) continue;
            session.closeNow();
        }
        this.sessions.clear();
        super.close();
    }
}

