/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.isger.brick.auth.AuthIdentity;
import net.isger.brick.auth.AuthToken;
import net.isger.brick.bus.BusCommand;
import net.isger.brick.bus.MinaEndpoint;
import net.isger.util.Asserts;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.nio.NioDatagramAcceptor;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaInbound
extends MinaEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(MinaInbound.class);

    @Override
    protected final void open() {
        super.open();
        InetSocketAddress address = this.getAddress();
        try {
            LOG.info("Listening [{}://{}]", (Object)this.getProtocolName(), (Object)address);
            ((IoAcceptor)this.getService()).bind((SocketAddress)address);
        }
        catch (Exception e) {
            throw Asserts.state((String)"Failure to bind [%s]", (Object[])new Object[]{address, e});
        }
    }

    protected IoAcceptor createService() {
        if ("udp".equalsIgnoreCase(this.getChannel())) {
            return new NioDatagramAcceptor();
        }
        return new NioSocketAcceptor();
    }

    protected IoSession getSession(BusCommand cmd) {
        Object credentitals;
        AuthIdentity identity = cmd.getIdentity();
        AuthToken token = identity.getToken();
        if (token != null && (credentitals = token.getCredentials()) instanceof IoSession) {
            return (IoSession)credentitals;
        }
        return null;
    }

    public void send(BusCommand cmd) {
        IoSession session;
        Object payload = cmd.getPayload();
        if (payload != null && (session = this.getSession(cmd)) != null) {
            session.write(payload);
        }
    }

    @Override
    protected void close() {
        ((SocketAcceptor)this.getService()).unbind();
        super.close();
    }
}

