/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.auth;

import net.isger.brick.auth.AuthIdentity;
import net.isger.brick.auth.AuthToken;
import net.isger.brick.auth.BaseAuth;
import net.isger.brick.auth.ShiroIdentity;
import net.isger.brick.auth.ShiroToken;
import net.isger.brick.core.BaseCommand;
import net.isger.brick.core.Command;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.WildcardPermission;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroAuth
extends BaseAuth {
    private static final Logger LOG = LoggerFactory.getLogger(ShiroAuth.class);

    protected AuthIdentity createIdentity() {
        return new ShiroIdentity();
    }

    protected ShiroToken login(AuthIdentity identity, AuthToken<?> token) {
        AuthToken pending = identity.getToken();
        if (!(pending instanceof ShiroToken) && (pending = ShiroAuth.transform(token)) == null) {
            return null;
        }
        return this.login(identity, (ShiroToken)pending);
    }

    private ShiroToken login(AuthIdentity identity, ShiroToken token) {
        try {
            token.getSubject().login((AuthenticationToken)token);
        }
        catch (Exception e) {
            LOG.warn("(!) Failure to login", (Throwable)e);
            return null;
        }
        return (ShiroToken)super.login(identity, (AuthToken)token);
    }

    protected Object check(AuthIdentity identity, Object token) {
        AuthToken shiroToken = this.login(identity, identity.getToken());
        if (shiroToken == null) {
            return false;
        }
        boolean result = true;
        try {
            String permission = token instanceof Command ? BaseCommand.cast((Command)((Command)token)).getPermission() : token.toString();
            Subject subject = shiroToken.getSubject();
            subject.getSession().touch();
            subject.checkPermission(permission);
        }
        catch (Throwable e) {
            result = false;
        }
        return result;
    }

    protected boolean isIgnore(Object token) {
        if (token instanceof Command) {
            WildcardPermission permission = new WildcardPermission(BaseCommand.cast((Command)((Command)token)).getPermission().replaceAll("[.]", ":"));
            for (String ignore : this.checker.getIgnores()) {
                if (!new WildcardPermission(ignore.replaceAll("[.]", ":")).implies((Permission)permission)) continue;
                return true;
            }
        }
        return super.isIgnore(token);
    }

    protected void logout(AuthIdentity identity) {
        AuthToken pending = identity.getToken();
        if (pending instanceof ShiroToken) {
            try {
                ((ShiroToken)pending).getSubject().logout();
            }
            catch (Exception e) {
                LOG.warn("Failure to logout [{}]", (Object)e.getMessage(), (Object)e.getCause());
            }
        }
        super.logout(identity);
    }

    public static ShiroToken transform(Object token) {
        if (!(token instanceof ShiroToken)) {
            token = token instanceof AuthenticationToken ? new ShiroToken(new AuthToken<AuthenticationToken>((AuthenticationToken)token){

                public Object getPrincipal() {
                    return ((AuthenticationToken)this.source).getPrincipal();
                }

                public Object getCredentials() {
                    return ((AuthenticationToken)this.source).getCredentials();
                }
            }) : (token instanceof AuthToken ? new ShiroToken((AuthToken)token) : null);
        }
        return (ShiroToken)((Object)token);
    }
}

