/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.stub.model;

import java.util.List;
import net.isger.brick.stub.model.Field;
import net.isger.brick.stub.model.Fields;
import net.isger.brick.stub.model.Model;
import net.isger.util.Sqls;

public class BaseModel
implements Model {
    private String name;
    private Fields fields = new Fields();

    public BaseModel() {
    }

    public BaseModel(Object ... fields) {
        this();
        for (Object field : fields) {
            if (field instanceof Object[]) {
                this.addField((Object[])field);
                continue;
            }
            if (!(field instanceof Field)) continue;
            this.addField((Field)field);
        }
    }

    @Override
    public String getModelName() {
        Class<?> clazz = this.getClass();
        if (this.name == null && clazz != BaseModel.class) {
            this.name = Sqls.getTableName(clazz, (String)"Model$");
        }
        return this.name;
    }

    protected void addField(Field field) {
        this.fields.add(field);
    }

    protected Field addField(Object ... args) {
        Field field = new Field(args);
        this.addField(field);
        return field;
    }

    @Override
    public List<String> getFieldNames() {
        return this.fields.getNames();
    }

    @Override
    public Field getField(String name) {
        return this.fields.get(name);
    }

    protected Object getFieldValue(String name) {
        return this.getField(name).getValue();
    }

    protected void setFieldValue(String name, Object value) {
        this.getField(name).setValue(value);
    }
}

