/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.stub.dialect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.isger.brick.stub.dialect.Describer;
import net.isger.brick.stub.dialect.Dialect;
import net.isger.brick.stub.dialect.Page;
import net.isger.brick.stub.dialect.PageSql;
import net.isger.brick.stub.model.Field;
import net.isger.brick.stub.model.Model;
import net.isger.util.Helpers;
import net.isger.util.Reflects;
import net.isger.util.Sqls;
import net.isger.util.Strings;
import net.isger.util.reflect.BoundField;
import net.isger.util.sql.SqlEntry;

public abstract class SqlDialect
implements Dialect {
    private static final Describer STRING_DESCRIBER = new Describer(){

        @Override
        public String describe() {
            return "VARCHAR(50)";
        }

        @Override
        public String describe(Field field) {
            return "VARCHAR(" + field.getLength() + ")";
        }
    };
    private static final Describer DATE_DESCRIBER = new Describer(){

        @Override
        public String describe() {
            return "DATE";
        }

        @Override
        public String describe(Field field) {
            return "DATE";
        }
    };
    private String name;
    private Map<String, Describer> describers = new HashMap<String, Describer>();

    public SqlDialect() {
        this.addDescriber("string", STRING_DESCRIBER);
        this.addDescriber("date", DATE_DESCRIBER);
    }

    @Override
    public String getName() {
        if (Strings.isEmpty((String)this.name)) {
            this.name = Helpers.getAliasName(this.getClass(), (String)"Dialect$");
        }
        return this.name;
    }

    @Override
    public boolean isSupport(String name) {
        return this.getName().equalsIgnoreCase(name);
    }

    @Override
    public SqlEntry getCreateEntry(Object table) {
        return this.getCreateEntry(this.getTableName(table), this.getColumnDescribes(table));
    }

    @Override
    public SqlEntry getCreateEntry(String table, String[][] describes) {
        StringBuffer sql = new StringBuffer(512);
        sql.append("CREATE TABLE ").append(table).append("(");
        for (String[] describe : describes) {
            int count = describe.length;
            for (int i = 0; i < count; ++i) {
                sql.append(describe[i]).append(" ");
            }
            sql.setLength(sql.length() - 1);
            sql.append(", ");
        }
        sql.setLength(sql.length() - 2);
        sql.append(")");
        return new SqlEntry(sql.toString(), new Object[0]);
    }

    @Override
    public SqlEntry getInsertEntry(Object table) {
        return this.getInsertEntry(this.getTableName(table), this.getTableData(table));
    }

    @Override
    public SqlEntry getInsertEntry(String tableName, Object[] gridData) {
        StringBuffer sql = new StringBuffer(512);
        StringBuffer params = new StringBuffer(128);
        sql.append("INSERT INTO ").append(tableName).append("(");
        Object[] columns = (Object[])gridData[0];
        int count = columns.length;
        for (int i = 0; i < count; ++i) {
            sql.append(columns[i]).append(", ");
            params.append("?, ");
        }
        sql.setLength(sql.length() - 2);
        sql.append(") VALUES (");
        params.setLength(params.length() - 2);
        sql.append(params);
        sql.append(")");
        return new SqlEntry(sql.toString(), (Object[])gridData[1]);
    }

    @Override
    public SqlEntry getDeleteEntry(Object table) {
        return this.getDeleteEntry(this.getTableName(table), this.getTableData(table));
    }

    @Override
    public SqlEntry getDeleteEntry(String tableName, Object[] gridData) {
        StringBuffer sql = new StringBuffer(512);
        sql.append("DELETE FROM ").append(tableName).append(" WHERE 1 = 1");
        Object[] columns = (Object[])gridData[0];
        int count = columns.length;
        if (gridData.length == 3 && Strings.isNotEmpty((String)((String)gridData[2]))) {
            throw new IllegalStateException("Unsupported feature in the current version");
        }
        for (int i = 0; i < count; ++i) {
            sql.append(" AND ").append(columns[i]).append(" = ?");
        }
        return new SqlEntry(sql.toString(), (Object[])gridData[1]);
    }

    @Override
    public SqlEntry getUpdateEntry(Object newTable, Object oldTable) {
        return this.getUpdateEntry(this.getTableName(newTable), this.getTableData(newTable), this.getTableData(oldTable));
    }

    @Override
    public SqlEntry getUpdateEntry(String tableName, Object[] newGridData, Object[] oldGridData) {
        int i;
        StringBuffer sql = new StringBuffer(512);
        sql.append("UPDATE ").append(tableName).append(" SET ");
        Object[] columns = (Object[])newGridData[0];
        int count = columns.length;
        for (i = 0; i < count; ++i) {
            sql.append(columns[i]).append(" = ?, ");
        }
        sql.setLength(sql.length() - 2);
        sql.append(" WHERE 1 = 1");
        columns = (String[])oldGridData[0];
        count = columns.length;
        if (oldGridData.length == 3 && Strings.isNotEmpty((String)((String)oldGridData[2]))) {
            throw new IllegalStateException("Unsupported feature in the current version");
        }
        for (i = 0; i < count; ++i) {
            sql.append(" AND ").append(columns[i]).append(" = ?");
        }
        return new SqlEntry(sql.toString(), this.fusion(newGridData[1], oldGridData[1]));
    }

    @Override
    public SqlEntry getSearchEntry(Object table) {
        return this.getSearchEntry(this.getTableName(table), this.getColumnNames(table), this.getTableData(table));
    }

    @Override
    public SqlEntry getSearchEntry(String tableName, Object[] columns, Object[] gridData) {
        int i;
        StringBuffer sql = new StringBuffer(512);
        StringBuffer restrict = new StringBuffer(128);
        sql.append("SELECT ");
        int count = columns.length;
        for (i = 0; i < count; ++i) {
            sql.append(columns[i]).append(", ");
        }
        sql.setLength(sql.length() - 2);
        sql.append(" FROM ").append(tableName).append(" WHERE 1 = 1");
        columns = (String[])gridData[0];
        count = columns.length;
        if (gridData.length == 3 && Strings.isNotEmpty((String)((String)gridData[2]))) {
            throw new IllegalStateException("Unsupported feature in the current version");
        }
        for (i = 0; i < count; ++i) {
            restrict.append(" AND ").append(columns[i]).append(" = ?");
        }
        sql.append(restrict);
        return this.getSearchEntry(sql.toString(), (Object[])gridData[1]);
    }

    @Override
    public SqlEntry getSearchEntry(String sql, Object[] values) {
        Page page = this.getPage(values);
        if (page == null) {
            return new SqlEntry(sql, values);
        }
        Object[] target = new Object[values.length - 1];
        System.arraycopy(values, 0, target, 0, target.length);
        return this.getSearchEntry(page, sql, target);
    }

    protected SqlEntry getSearchEntry(Page page, String sql, Object[] values) {
        return new PageSql(page, sql, values);
    }

    protected Page getPage(Object[] values) {
        if (values != null && values.length > 0 && values[values.length - 1] instanceof Page) {
            return (Page)values[values.length - 1];
        }
        return null;
    }

    @Override
    public SqlEntry getRemoveEntry(Object table) {
        return new SqlEntry(new StringBuffer("DROP TABLE ").append(this.getTableName(table)).toString(), new Object[0]);
    }

    protected String getTableName(Object table) {
        if (table instanceof Model) {
            return ((Model)table).getModelName();
        }
        if (table instanceof String) {
            return (String)table;
        }
        return Sqls.getTableName(table.getClass());
    }

    protected String[] getColumnNames(Object table) {
        if (table instanceof Model) {
            return this.getColumnNames((Model)table);
        }
        ArrayList<String> columns = new ArrayList<String>();
        for (List fields : Reflects.getBoundFields(table.getClass()).values()) {
            BoundField field = (BoundField)fields.get(0);
            String column = field.getAliasName();
            if (column == null) {
                column = Sqls.toColumnName((String)field.getName());
            }
            columns.add(column);
        }
        return columns.toArray(new String[columns.size()]);
    }

    protected String[] getColumnNames(Model table) {
        List<String> fieldNames = table.getFieldNames();
        return fieldNames.toArray(new String[fieldNames.size()]);
    }

    protected String[][] getColumnDescribes(Object table) {
        if (table instanceof Model) {
            return this.getColumnDescribes((Model)((Object)table));
        }
        if (!(table instanceof Class)) {
            table = table.getClass();
        }
        BoundField[] fields = Reflects.getBoundFields((Class)table).values().toArray(new BoundField[0]);
        int size = fields.length;
        String[][] describes = new String[size][];
        for (int i = 0; i < size; ++i) {
            describes[i] = new String[2];
            describes[i][0] = fields[i].getAliasName();
            if (describes[i][0] == null) {
                describes[i][0] = Sqls.toColumnName((String)fields[i].getName());
            }
            describes[i][1] = fields[i].getField().getType().getSimpleName().toLowerCase();
            Describer describer = this.describers.get(describes[i][1]);
            if (describer == null) {
                describer = this.describers.get("string");
            }
            describes[i][1] = describer.describe();
        }
        return describes;
    }

    protected String[][] getColumnDescribes(Model table) {
        List<String> fieldNames = table.getFieldNames();
        int fieldCount = fieldNames.size();
        String[][] describes = new String[fieldCount][];
        for (int i = 0; i < fieldCount; ++i) {
            describes[i] = this.getColumnDescribe(table.getField(fieldNames.get(i)));
        }
        return describes;
    }

    protected String[] getColumnDescribe(Field field) {
        String type = field.getType().toLowerCase();
        Describer describer = this.describers.get(type);
        if (describer != null) {
            type = describer.describe(field);
        }
        return new String[]{field.getName(), type};
    }

    protected Object[] getTableData(Object table) {
        if (table instanceof Model) {
            return this.getTableData((Model)table);
        }
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Object> row = new ArrayList<Object>();
        for (List fields : Reflects.getBoundFields(table.getClass()).values()) {
            Object value;
            BoundField field = (BoundField)fields.get(0);
            String column = field.getAliasName();
            if (column == null) {
                column = Sqls.toColumnName((String)field.getName());
            }
            if ((value = field.getValue(table)) == null) continue;
            columns.add(column);
            row.add(value);
        }
        return new Object[]{columns.toArray(new String[columns.size()]), row.toArray()};
    }

    protected Object[] getTableData(Model table) {
        List<String> fieldNames = table.getFieldNames();
        int fieldCount = fieldNames.size();
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Object> row = new ArrayList<Object>();
        for (int i = 0; i < fieldCount; ++i) {
            String column = fieldNames.get(i);
            Object value = table.getField(column).getValue();
            if (value == null) continue;
            columns.add(column);
            row.add(value);
        }
        return new Object[]{columns.toArray(new String[columns.size()]), row.toArray()};
    }

    protected void addDescriber(String type, Describer describer) {
        this.describers.put(type, describer);
    }

    private Object[] fusion(Object array1, Object array2) {
        Object[] result;
        if (array1 instanceof Object[][]) {
            Object[][] newData = (Object[][])array1;
            Object[][] oldData = (Object[][])array2;
            int count = newData.length;
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            for (int i = 0; i < count; ++i) {
                ArrayList<Object> row = new ArrayList<Object>();
                row.addAll(Arrays.asList(newData[i]));
                row.addAll(Arrays.asList(oldData[i]));
                rows.add(row.toArray());
            }
            result = rows.toArray((T[])new Object[rows.size()][]);
        } else {
            ArrayList<Object> row = new ArrayList<Object>();
            row.addAll(Arrays.asList((Object[])array1));
            row.addAll(Arrays.asList((Object[])array2));
            result = row.toArray();
        }
        return result;
    }
}

