/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.stub;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import net.isger.brick.stub.AbstractStub;
import net.isger.brick.stub.BaseDataSource;
import net.isger.brick.stub.Condition;
import net.isger.brick.stub.Dialects;
import net.isger.brick.stub.StubCommand;
import net.isger.brick.stub.dialect.Dialect;
import net.isger.brick.stub.dialect.PageSql;
import net.isger.util.Callable;
import net.isger.util.Helpers;
import net.isger.util.Sqls;
import net.isger.util.Strings;
import net.isger.util.anno.Ignore;
import net.isger.util.sql.SqlEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class SqlStub
extends AbstractStub {
    public static final String PARAM_JNDINAME = "jndiName";
    public static final String PARAM_DRIVERNAME = "driverName";
    public static final String PARAM_URL = "url";
    public static final String PARAM_USER = "user";
    public static final String PARAM_PASSWORD = "password";
    private static final Logger LOG = LoggerFactory.getLogger(SqlStub.class);
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private String dialectName;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private DataSource dataSource;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private Dialect dialect;

    @Ignore
    public void initial() {
        if (this.dataSource == null) {
            String value = this.getJndiName();
            if (Strings.isNotEmpty((String)value)) {
                try {
                    this.dataSource = (DataSource)new InitialContext().lookup(value.trim());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Couldn't lookup DataSource from " + value + " - " + e.getMessage(), e);
                }
            } else {
                value = this.getUrl();
                if (Strings.isNotEmpty((String)value) && Strings.isNotEmpty((String)this.getDriverName())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.info("Initializing DataSource url {}", (Object)value);
                    }
                    this.dataSource = new BaseDataSource(this.getDriverName(), value, this.getUser(), this.getPassword());
                } else {
                    throw new IllegalStateException("Unexpected DataSource or JDBC configuration. Make sure you use is the SQL stub");
                }
            }
        }
        String name = this.getDialectName();
        if (this.dialect == null) {
            this.dialect = Dialects.getDialect(name);
            if (this.dialect == null) {
                this.dialect = Dialects.getDialect(this.getDriverName());
            }
            name = this.dialect.getName();
        }
        this.dialectName = name;
    }

    protected String getDialectName() {
        return this.dialectName;
    }

    protected String getJndiName() {
        return (String)this.getParameter(PARAM_JNDINAME);
    }

    protected String getDriverName() {
        return (String)this.getParameter(PARAM_DRIVERNAME);
    }

    protected String getUrl() {
        return (String)this.getParameter(PARAM_URL);
    }

    protected String getUser() {
        return (String)this.getParameter(PARAM_USER);
    }

    protected String getPassword() {
        return (String)this.getParameter(PARAM_PASSWORD);
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected Dialect getDialect() {
        return this.dialect;
    }

    protected Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failure to connect database", e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Ignore
    public void create(StubCommand cmd) {
        Object result;
        Object table = cmd.getTable();
        final Connection conn = this.getConnection();
        Object[] condition = this.getCondition(cmd, 3);
        try {
            result = table instanceof String ? Sqls.modify((SqlEntry)this.dialect.getCreateEntry((String)table, (String[][])condition[0]), (Connection)conn) : (table instanceof Class ? (condition == null ? Sqls.modify((SqlEntry)this.dialect.getCreateEntry((Class)table), (Connection)conn) : this.modify(cmd.getOperate(), (Class)table, condition, conn)) : this.each(table, new Callable<Object>(){

                public Object call(Object ... args) {
                    return Sqls.modify((SqlEntry)SqlStub.this.dialect.getCreateEntry(args[0]), (Connection)conn);
                }
            }));
        }
        finally {
            this.close(conn);
        }
        cmd.setResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Ignore
    public void insert(StubCommand cmd) {
        Object result;
        Object table = cmd.getTable();
        Object[] condition = this.getCondition(cmd, 3);
        final Connection conn = this.getConnection();
        try {
            result = table instanceof String ? Sqls.modify((SqlEntry)this.dialect.getInsertEntry((String)table, condition), (Connection)conn) : (table instanceof Class ? this.modify(cmd.getOperate(), (Class)table, condition, conn) : this.each(table, new Callable<Object>(){

                public Object call(Object ... args) {
                    return Sqls.modify((SqlEntry)SqlStub.this.dialect.getInsertEntry(args[0]), (Connection)conn);
                }
            }));
        }
        finally {
            this.close(conn);
        }
        cmd.setResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Ignore
    public void delete(StubCommand cmd) {
        Object result;
        Object table = cmd.getTable();
        Object[] condition = this.getCondition(cmd, 3);
        final Connection conn = this.getConnection();
        try {
            result = table instanceof String ? Sqls.modify((SqlEntry)this.dialect.getDeleteEntry((String)table, (Object[])condition[0]), (Connection)conn) : (table instanceof Class ? this.modify(cmd.getOperate(), (Class)table, condition, conn) : this.each(table, new Callable<Object>(){

                public Object call(Object ... args) {
                    return Sqls.modify((SqlEntry)SqlStub.this.dialect.getDeleteEntry(args[0]), (Connection)conn);
                }
            }));
        }
        finally {
            this.close(conn);
        }
        cmd.setResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Ignore
    public void update(StubCommand cmd) {
        Object result;
        Object table = cmd.getTable();
        Object[] condition = this.getCondition(cmd, 3);
        final Connection conn = this.getConnection();
        try {
            if (table instanceof String) {
                Object[][] values = (Object[][])condition[0];
                result = Sqls.modify((SqlEntry)this.dialect.getUpdateEntry((String)table, values[0], values[1]), (Connection)conn);
            } else {
                result = table instanceof Class ? this.modify(cmd.getOperate(), (Class)table, condition, conn) : this.each(new Object[]{(Object[])table}, new Callable<Object>(){

                    public Object call(Object ... args) {
                        return Sqls.modify((SqlEntry)SqlStub.this.dialect.getUpdateEntry(args[0], args[1]), (Connection)conn);
                    }
                });
            }
        }
        finally {
            this.close(conn);
        }
        cmd.setResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Ignore
    public void search(StubCommand cmd) {
        Object[] result;
        block8: {
            Object table = cmd.getTable();
            Object[] condition = this.getCondition(cmd, 3);
            final Connection conn = this.getConnection();
            try {
                String countSql;
                SqlEntry sqlEntry;
                if (table instanceof String) {
                    sqlEntry = this.dialect.getSearchEntry((String)table, (String[])condition[0], (Object[])condition[1]);
                    result = Sqls.query((SqlEntry)sqlEntry, (Connection)conn);
                } else {
                    if (!(table instanceof Class)) {
                        result = (Object[])this.each(table, new Callable<Object>(){

                            public Object call(Object ... args) {
                                return Sqls.query((SqlEntry)SqlStub.this.dialect.getSearchEntry(args[0]), (Connection)conn);
                            }
                        });
                        break block8;
                    }
                    this.canonicalize(cmd.getOperate(), condition);
                    String sql = Sqls.getSQL((Class)((Class)table), (String)this.dialectName, (String)((String)condition[0]), (Object[])((Object[])condition[2]));
                    sqlEntry = this.dialect.getSearchEntry(sql, (Object[])condition[1]);
                    result = Sqls.query((SqlEntry)sqlEntry, (Connection)conn);
                }
                if (sqlEntry instanceof PageSql && (countSql = ((PageSql)sqlEntry).getCountSql()) != null) {
                    Object[] target = new Object[result.length + 1];
                    System.arraycopy(result, 0, target, 0, result.length);
                    target[result.length] = ((Number)((Object[][])Sqls.query((String)countSql, (Object[])sqlEntry.getValues(), (Connection)conn)[1])[0][0]).longValue();
                    result = target;
                }
            }
            finally {
                this.close(conn);
            }
        }
        cmd.setResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Ignore
    public void remove(StubCommand cmd) {
        Object result;
        Object table = cmd.getTable();
        final Connection conn = this.getConnection();
        try {
            result = this.each(table, new Callable<Object>(){

                public Object call(Object ... args) {
                    return Sqls.modify((SqlEntry)SqlStub.this.dialect.getRemoveEntry(args[0]), (Connection)conn);
                }
            });
        }
        finally {
            this.close(conn);
        }
        cmd.setResult(result);
    }

    protected Object each(Object table, Callable<Object> callable) {
        int size;
        if (table instanceof Collection) {
            Collection instance = (Collection)table;
            size = instance.size();
            table = instance.toArray(new Object[size]);
        } else if (table.getClass().isArray()) {
            size = Array.getLength(table);
        } else {
            size = 1;
            table = new Object[]{table};
        }
        Object[] result = new Object[size];
        for (int i = 0; i < size; ++i) {
            Object instance = Array.get(table, i);
            result[i] = instance != null && instance.getClass().isArray() ? callable.call((Object[])instance) : callable.call(new Object[]{instance});
        }
        return size == 1 ? result[0] : result;
    }

    protected Object[] getCondition(StubCommand cmd, int type) {
        Object config = cmd.getCondition();
        if (config instanceof Condition) {
            throw new IllegalStateException("Unsupported feature in the current version");
        }
        return (Object[])Helpers.copyArray((Object)config, (int)type);
    }

    protected Object modify(String operate, Class<?> table, Object[] condition, Connection conn) {
        this.canonicalize(operate, condition);
        Object values = condition[1];
        String sql = Sqls.getSQL(table, (String)this.dialectName, (String)((String)condition[0]), (Object[])((Object[])condition[2]));
        return values instanceof Object[][] ? Sqls.modify((String)sql, (Object[][])((Object[][])values), (Connection)conn) : (int[])Sqls.modify((String)sql, (Object[])((Object[])values), (Connection)conn);
    }

    private void canonicalize(String operate, Object[] condition) {
        if (condition[0] != null && !(condition[0] instanceof String)) {
            int index = condition.length - 1;
            while (index > 0) {
                condition[index--] = condition[index];
            }
            condition[index] = operate;
        }
    }

    public void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Ignore
    public void destroy() {
    }
}

