/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.stub;

import java.util.Hashtable;
import java.util.Map;
import net.isger.brick.stub.dialect.DerbyDialect;
import net.isger.brick.stub.dialect.Dialect;
import net.isger.brick.stub.dialect.H2Dialect;
import net.isger.brick.stub.dialect.MySQLDialect;
import net.isger.brick.stub.dialect.OracleDialect;
import net.isger.util.hitch.Director;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dialects {
    private static final String KEY_DIALECTS = "brick.core.dialects";
    private static final String DIALECT_PATH = "net/isger/brick/stub/dialect";
    private static final Logger LOG = LoggerFactory.getLogger(Dialects.class);
    private static final Dialects DIALECTS = new Dialects();
    private Map<String, Dialect> dialects = new Hashtable<String, Dialect>();

    private Dialects() {
    }

    public static void addDialect(Dialect dialect) {
        String name = dialect.getClass().getName();
        if (LOG.isDebugEnabled()) {
            LOG.info("Achieve dialect [{}]", (Object)name);
        }
        if ((dialect = Dialects.DIALECTS.dialects.put(name, dialect)) != null && LOG.isDebugEnabled()) {
            LOG.warn("(!) Discard dialect [{}]", (Object)dialect);
        }
    }

    public static Dialect getDialect(String driverName) {
        Dialect result = null;
        for (Dialect dialect : Dialects.DIALECTS.dialects.values()) {
            if (!dialect.isSupport(driverName)) continue;
            result = dialect;
            break;
        }
        return result;
    }

    static {
        Dialects.addDialect(new H2Dialect());
        Dialects.addDialect(new MySQLDialect());
        Dialects.addDialect(new OracleDialect());
        Dialects.addDialect(new DerbyDialect());
        new Director(){

            protected String directPath() {
                return this.directPath(Dialects.KEY_DIALECTS, Dialects.DIALECT_PATH);
            }
        }.direct((Object)DIALECTS);
    }
}

