/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.sched;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.isger.brick.core.Gate;
import net.isger.brick.core.GateCommand;
import net.isger.brick.core.GateModule;
import net.isger.brick.plugin.PluginCommand;
import net.isger.brick.sched.BaseSched;
import net.isger.brick.sched.Sched;
import net.isger.util.Asserts;
import net.isger.util.Dates;
import net.isger.util.Strings;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class SchedModule
extends GateModule {
    private static final String META_SCHED = "meta.sched";
    private Scheduler scheduler;
    private Map<Sched, JobKey> jobKeys = new HashMap<Sched, JobKey>();

    public Class<? extends Gate> getTargetClass() {
        Class<Sched> targetClass = super.getTargetClass();
        if (targetClass == null) {
            targetClass = Sched.class;
        } else {
            Asserts.isAssignable(Sched.class, targetClass, (String)"The schedule %s must implement the %s", (Object[])new Object[]{targetClass, Sched.class});
        }
        return targetClass;
    }

    public Class<? extends Gate> getImplementClass() {
        return BaseSched.class;
    }

    public void initial() {
        super.initial();
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            for (Map.Entry entry : this.getGates().entrySet()) {
                this.createJob((String)entry.getKey(), (Sched)entry.getValue());
            }
            this.scheduler.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failure to create scheduler", e);
        }
    }

    public void create() {
        GateCommand cmd = GateCommand.getAction();
        super.create();
        if (!cmd.getTransient()) {
            Map scheds = (Map)cmd.getResult();
            for (Map.Entry entry : scheds.entrySet()) {
                Sched sched = (Sched)entry.getValue();
                try {
                    sched.create();
                    this.createJob((String)entry.getKey(), sched);
                }
                catch (Exception e) {
                    sched.remove();
                    throw new IllegalStateException("Failure to create schedule", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        GateCommand cmd = GateCommand.getAction();
        for (Map.Entry entry : cmd.getParameter().entrySet()) {
            Sched sched = (Sched)this.getGate((String)entry.getKey());
            if (sched == null) continue;
            try {
                JobKey key = this.jobKeys.get(sched);
                if (key == null) continue;
                JobKey jobKey = key;
                synchronized (jobKey) {
                    this.scheduler.pauseJob(key);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failure to pause schedule", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        GateCommand cmd = GateCommand.getAction();
        for (Map.Entry entry : cmd.getParameter().entrySet()) {
            Sched sched = (Sched)this.getGate((String)entry.getKey());
            if (sched == null) continue;
            try {
                JobKey key = this.jobKeys.get(sched);
                if (key == null) continue;
                JobKey jobKey = key;
                synchronized (jobKey) {
                    this.scheduler.resumeJob(key);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failure to pause schedule", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        GateCommand cmd = GateCommand.getAction();
        super.remove();
        Map scheds = (Map)cmd.getResult();
        for (Sched sched : scheds.values()) {
            try {
                JobKey key = this.jobKeys.get(sched);
                if (key != null) {
                    JobKey jobKey = key;
                    synchronized (jobKey) {
                        this.scheduler.deleteJob(key);
                    }
                    this.jobKeys.remove(sched);
                }
                sched.remove();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failure to remove schedule", e);
            }
        }
    }

    private void createJob(String name, Sched sched) throws Exception {
        String interval;
        PluginCommand cmd;
        String domain;
        if (sched instanceof BaseSched && Strings.isEmpty((String)(domain = (cmd = ((BaseSched)sched).getCommand()).getDomain()))) {
            cmd.setDomain(name);
        }
        String group = Strings.empty((String)sched.getGroup(), (String)"default");
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
        triggerBuilder.withIdentity(name, group);
        triggerBuilder.startAt(Dates.getDate((Date)sched.getEffective(), (int)sched.getDelay()));
        Date deadline = sched.getDeadline();
        if (deadline != null) {
            triggerBuilder.endAt(deadline);
        }
        if (Strings.isNotEmpty((String)(interval = sched.getInterval()))) {
            triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)interval));
        }
        JobBuilder jobBuilder = JobBuilder.newJob(BaseJob.class);
        jobBuilder.withIdentity(name, group);
        JobDetail detail = jobBuilder.build();
        JobDataMap data = detail.getJobDataMap();
        data.put(META_SCHED, (Object)sched);
        this.scheduler.scheduleJob(detail, triggerBuilder.build());
        this.jobKeys.put(sched, detail.getKey());
    }

    public void destroy() {
        try {
            this.scheduler.shutdown(true);
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
        super.destroy();
    }

    public static final class BaseJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobDataMap data = context.getJobDetail().getJobDataMap();
            Sched sched = (Sched)data.get((Object)SchedModule.META_SCHED);
            sched.action();
        }
    }
}

