/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.plugin.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.isger.brick.plugin.service.Service;
import net.isger.util.Helpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Services {
    private static final Logger LOG = LoggerFactory.getLogger(Services.class);
    private Map<String, Service> services = new HashMap<String, Service>();

    public Services() {
        this(null);
    }

    public Services(List<Object> services) {
        if (services != null) {
            for (Object instance : services) {
                if (instance instanceof Service) {
                    this.add((Service)instance);
                    continue;
                }
                if (!(instance instanceof Map)) continue;
                for (Map.Entry entry : ((Map)instance).entrySet()) {
                    instance = entry.getValue();
                    if (!(instance instanceof Service)) continue;
                    this.put((String)entry.getKey(), (Service)instance);
                }
            }
        }
    }

    public void add(Service service) {
        this.put(null, service);
    }

    public void put(String name, Service service) {
        name = Helpers.getAliasName(service.getClass(), (String)"Service$", (String)name).toLowerCase();
        if (LOG.isDebugEnabled()) {
            LOG.info("Binding [{}] service [{}]", (Object)name, (Object)service);
        }
        if ((service = this.services.put(name, service)) != null) {
            LOG.warn("(!) Discard [{}] service [{}]", (Object)name, (Object)service);
        }
    }

    public Service get(String name) {
        return this.services.get(name);
    }
}

