/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.plugin.persist;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.isger.brick.plugin.persist.Persist;
import net.isger.util.Helpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Persists {
    private static final Logger LOG = LoggerFactory.getLogger(Persists.class);
    private Map<String, Persist> persists = new HashMap<String, Persist>();

    public Persists() {
        this(null);
    }

    public Persists(List<Object> persists) {
        if (persists != null) {
            for (Object instance : persists) {
                if (instance instanceof Persist) {
                    this.add((Persist)instance);
                    continue;
                }
                if (!(instance instanceof Map)) continue;
                for (Map.Entry entry : ((Map)instance).entrySet()) {
                    instance = entry.getValue();
                    if (!(instance instanceof Persist)) continue;
                    this.put((String)entry.getKey(), (Persist)instance);
                }
            }
        }
    }

    public void add(Persist persist) {
        this.put(null, persist);
    }

    public void put(String name, Persist persist) {
        name = Helpers.getAliasName(persist.getClass(), (String)"Persist$", (String)name).toLowerCase();
        if (LOG.isDebugEnabled()) {
            LOG.info("Binding [{}] persist [{}]", (Object)name, (Object)persist);
        }
        if ((persist = this.persists.put(name, persist)) != null) {
            LOG.warn("(!) Discard [{}] service [{}]", (Object)name, (Object)persist);
        }
    }

    public Persist get(String name) {
        return this.persists.get(name);
    }
}

