/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus;

import java.net.SocketAddress;
import net.isger.brick.bus.BusCommand;
import net.isger.brick.bus.MinaEndpoint;
import net.isger.brick.bus.Status;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaOutbound
extends MinaEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(MinaOutbound.class);
    private transient IoSession session;

    @Override
    protected void open() {
        super.open();
        this.status = Status.ACTIVATED;
    }

    @Override
    protected IoService createService() {
        return new NioSocketConnector();
    }

    protected IoSession getSession() {
        IoSession session = this.session;
        if (session == null || session.isClosing()) {
            ConnectFuture future = ((SocketConnector)this.getService()).connect((SocketAddress)this.address);
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                session = future.getSession();
                if (session == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.info("Connected to {}://{}", (Object)this.protocol, (Object)this.address);
                }
                this.session = session;
                break;
            } while (!Thread.interrupted());
        }
        return session;
    }

    public void send() {
        Object payload = BusCommand.getAction().getPayload();
        if (payload != null) {
            this.getSession().write(payload);
        }
    }

    @Override
    protected void close() {
        if (this.session != null && this.session.isConnected()) {
            this.session.close(true);
            this.session = null;
        }
        this.status = Status.DEACTIVATED;
        super.close();
    }
}

