/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus;

import java.io.IOException;
import java.net.SocketAddress;
import net.isger.brick.bus.MinaEndpoint;
import net.isger.brick.bus.Status;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.IoServiceListener;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaInbound
extends MinaEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(MinaInbound.class);

    @Override
    protected void open() {
        super.open();
        SocketAcceptor acceptor = (SocketAcceptor)this.getService();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.info("Listening [{}://{}]", (Object)this.protocol, (Object)this.address);
            }
            acceptor.bind((SocketAddress)this.address);
        }
        catch (IOException e) {
            throw new IllegalStateException("(X) Failure to bind [" + this.address + "]", e);
        }
    }

    @Override
    protected IoService createService() {
        NioSocketAcceptor service = new NioSocketAcceptor();
        service.addListener(new IoServiceListener(){

            public void serviceActivated(IoService service) throws Exception {
                MinaInbound.this.status = Status.ACTIVATED;
            }

            public void serviceIdle(IoService service, IdleStatus idleStatus) throws Exception {
            }

            public void serviceDeactivated(IoService service) throws Exception {
                MinaInbound.this.status = Status.DEACTIVATED;
            }

            public void sessionCreated(IoSession session) throws Exception {
            }

            public void sessionDestroyed(IoSession session) throws Exception {
            }
        });
        return service;
    }

    @Override
    protected void close() {
        ((SocketAcceptor)this.getService()).unbind();
        super.close();
    }
}

