/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus;

import net.isger.brick.bus.Bus;
import net.isger.brick.bus.SocketEndpoint;
import net.isger.brick.bus.Status;
import net.isger.brick.bus.protocol.Protocol;
import net.isger.brick.core.Command;
import net.isger.brick.core.Console;
import net.isger.util.anno.Alias;
import net.isger.util.anno.Ignore;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.serialization.ObjectSerializationDecoder;
import org.apache.mina.filter.codec.serialization.ObjectSerializationEncoder;

public abstract class MinaEndpoint
extends SocketEndpoint {
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="system")
    private Console console;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="system")
    private Bus bus;
    private IoService service;
    protected Status status;

    protected void open() {
        Object decoder;
        Object encoder;
        this.service = this.createService();
        final Protocol protocol = this.bus.getProtocol(this.protocol);
        if (protocol == null) {
            encoder = new ObjectSerializationEncoder();
            decoder = new ObjectSerializationDecoder();
        } else {
            encoder = new ProtocolEncoderAdapter(){

                public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
                    byte[] value = protocol.getEncoder().encode(message);
                    if (value != null) {
                        IoBuffer buf = IoBuffer.allocate((int)value.length).setAutoExpand(true);
                        buf.put(value);
                        buf.flip();
                        out.write((Object)buf);
                    }
                }
            };
            decoder = new CumulativeProtocolDecoder(){

                protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
                    boolean result;
                    Object message = protocol.getDecoder().decode(in.asInputStream());
                    boolean bl = result = message != null;
                    if (result) {
                        out.write(message);
                    }
                    return result;
                }
            };
        }
        DefaultIoFilterChainBuilder chain = this.service.getFilterChain();
        chain.addLast(this.protocol, (IoFilter)new ProtocolCodecFilter(new ProtocolCodecFactory((ProtocolEncoder)encoder, (ProtocolDecoder)decoder){
            final /* synthetic */ ProtocolEncoder val$encoder;
            final /* synthetic */ ProtocolDecoder val$decoder;
            {
                this.val$encoder = protocolEncoder;
                this.val$decoder = protocolDecoder;
            }

            public ProtocolEncoder getEncoder(IoSession session) throws Exception {
                return this.val$encoder;
            }

            public ProtocolDecoder getDecoder(IoSession session) throws Exception {
                return this.val$decoder;
            }
        }));
        IoHandlerAdapter ioHandler = this.handler == null ? new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object message) throws Exception {
                MinaEndpoint.this.console.execute((Command)message);
                session.write(message);
            }
        } : new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object message) throws Exception {
                if ((message = MinaEndpoint.this.handler.handle(message)) != null) {
                    session.write(message);
                }
            }
        };
        this.service.setHandler((IoHandler)ioHandler);
    }

    public Status getStatus() {
        return this.status;
    }

    protected abstract IoService createService();

    protected IoService getService() {
        return this.service;
    }

    protected void close() {
        this.service.dispose(true);
        this.service = null;
    }
}

