/*
 * Decompiled with CFR 0.152.
 */
package net.isger.raw;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.isger.raw.Prober;
import net.isger.raw.Shelf;
import net.isger.util.Files;

public class SuffixProber
implements Prober {
    private List<String> suffixes = new Vector<String>();

    public static SuffixProber create(String ... suffixes) {
        SuffixProber prober = new SuffixProber();
        for (String suffix : suffixes) {
            prober.addSuffix(suffix);
        }
        return prober;
    }

    public void addSuffix(String suffix) {
        String name = Files.getCanonical((String)suffix);
        if (name != null && !suffix.contains(File.separator) && !this.suffixes.contains(suffix)) {
            this.suffixes.add(suffix);
        }
    }

    @Override
    public List<Object> probe(Shelf shelf, String name) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String suffix : this.suffixes) {
            result.add(shelf.getResource(name + "." + suffix));
        }
        return result;
    }
}

