/*
 * Decompiled with CFR 0.152.
 */
package net.isger.raw;

import java.util.ArrayList;
import java.util.List;
import net.isger.raw.Prober;
import net.isger.raw.Shelf;

public class ProberMulticaster
implements Prober {
    private Prober prev;
    private Prober next;

    protected ProberMulticaster(Prober prev, Prober next) {
        this.prev = prev;
        this.next = next;
    }

    @Override
    public List<Object> probe(Shelf shelf, String name) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(this.prev.probe(shelf, name));
        result.addAll(this.next.probe(shelf, name));
        return result;
    }

    public static Prober add(Prober prev, Prober next) {
        if (prev == null) {
            return next;
        }
        if (next == null) {
            return prev;
        }
        return new ProberMulticaster(prev, next);
    }

    public static Prober remove(Prober prev, Prober next) {
        if (prev == next || prev == null) {
            return null;
        }
        if (prev instanceof ProberMulticaster) {
            return ((ProberMulticaster)prev).remove(next);
        }
        return prev;
    }

    protected Prober remove(Prober prober) {
        if (prober == this.prev) {
            return this.next;
        }
        if (prober == this.next) {
            return this.prev;
        }
        Prober a = ProberMulticaster.remove(this.prev, prober);
        Prober b = ProberMulticaster.remove(this.next, prober);
        if (a == this.prev && b == this.next) {
            return this;
        }
        return ProberMulticaster.add(a, b);
    }
}

