/*
 * Decompiled with CFR 0.152.
 */
package net.isger.raw;

import java.io.File;
import java.io.FileFilter;
import net.isger.raw.FileDepot;
import net.isger.raw.FileShelf;
import net.isger.raw.JarShelf;
import net.isger.util.Files;

public class JarDepot
extends FileDepot {
    private static final FileFilter FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile() && Files.isJar((String)file.getAbsolutePath());
        }
    };

    protected JarDepot() {
    }

    @Override
    protected boolean isMound(File file) {
        return super.isMound(file) || FILTER.accept(file);
    }

    @Override
    protected void mount(File file) {
        if (file.isDirectory()) {
            for (File path : file.listFiles(FILTER)) {
                super.mount(path);
            }
        } else {
            super.mount(file);
        }
    }

    @Override
    protected FileShelf createShelf(String path) {
        return new JarShelf(path);
    }
}

