/*
 * Decompiled with CFR 0.152.
 */
package net.isger.raw;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.isger.raw.AbstractDepot;
import net.isger.raw.FileShelf;
import net.isger.raw.Raw;
import net.isger.raw.UrlRaw;

public class FileDepot
extends AbstractDepot {
    @Override
    public final void mount(Object describe) {
        File file;
        if (describe instanceof File) {
            file = (File)describe;
        } else {
            if (describe instanceof URL) {
                describe = this.decode(((URL)describe).getFile());
            }
            file = new File(describe.toString());
        }
        if (file.exists() && this.isMound(file)) {
            this.mount(file);
        }
    }

    protected void mount(File file) {
        String path;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            return;
        }
        super.mount(this.createShelf(path));
    }

    protected FileShelf createShelf(String path) {
        return new FileShelf(path);
    }

    protected String decode(String path) {
        return path.replaceAll("(%20)", " ");
    }

    protected boolean isMound(File file) {
        return file.isDirectory();
    }

    @Override
    protected List<Raw> createRaws(Object resource) {
        ArrayList<Raw> result = new ArrayList<Raw>();
        URL url = (URL)resource;
        if (url != null) {
            result.add(new UrlRaw(url));
        }
        return result;
    }
}

