/*
 * Decompiled with CFR 0.152.
 */
package net.isger.raw;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.isger.raw.AbstractDepot;
import net.isger.raw.Depot;
import net.isger.raw.Raw;
import net.isger.raw.Shelf;
import net.isger.raw.UrlRaw;
import net.isger.util.Helpers;
import net.isger.util.Reflects;

public final class ClassLoaderDepot
extends AbstractDepot
implements Shelf {
    private static final Depot INSTANCE = new ClassLoaderDepot();
    private final ClassLoader loader = Reflects.getClassLoader((Object)this);

    private ClassLoaderDepot() {
        super.mount(this);
    }

    public static Depot getInstance() {
        return INSTANCE;
    }

    @Override
    public Object getResource(String name) {
        ArrayList result = new ArrayList();
        try {
            Helpers.add(result, this.loader.getResources(name));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void mount(Object describe) {
    }

    @Override
    protected List<Raw> createRaws(Object resource) {
        ArrayList<Raw> raws = new ArrayList<Raw>();
        for (URL url : (List)resource) {
            Helpers.add(raws, (Object)this.createRaw(url));
        }
        return raws;
    }

    protected Raw createRaw(URL url) {
        return url == null ? null : new UrlRaw(url);
    }

    @Override
    public void unmount(Object describe) {
    }

    public String toString() {
        return this.loader.getClass().getName();
    }
}

