/*
 * Decompiled with CFR 0.152.
 */
package net.isger.raw;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.isger.raw.Depot;
import net.isger.raw.Prober;
import net.isger.raw.Raw;
import net.isger.raw.Shelf;
import net.isger.util.Helpers;
import net.isger.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDepot
implements Depot {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDepot.class);
    private static final Prober NOP = new Prober(){
        private final List<Object> empty = Collections.unmodifiableList(new ArrayList());

        @Override
        public List<Object> probe(Shelf shelf, String name) {
            return this.empty;
        }
    };
    private String name;
    private List<Shelf> shelves = new ArrayList<Shelf>();

    protected AbstractDepot() {
    }

    public String name() {
        if (Strings.isEmpty((Object)this.name)) {
            this.name = Helpers.getAliasName(this.getClass(), (String)"Depot$");
        }
        return this.name;
    }

    @Override
    public void mount(Object describe) {
        if (describe instanceof Shelf && !this.shelves.contains(describe)) {
            if (LOG.isDebugEnabled()) {
                LOG.info("Achieve shelf [{}]", describe);
            }
            this.shelves.add((Shelf)describe);
        }
    }

    @Override
    public final List<Raw> search(String name, Prober prober) {
        if (prober == null) {
            prober = NOP;
        }
        ArrayList<Raw> result = new ArrayList<Raw>();
        for (Shelf shelf : this.shelves) {
            Helpers.add(result, this.createRaws(shelf.getResource(name)));
            for (Object resource : prober.probe(shelf, name)) {
                Helpers.add(result, this.createRaws(resource));
            }
        }
        return result;
    }

    protected abstract List<Raw> createRaws(Object var1);

    @Override
    public void unmount(Object describe) {
        if (describe instanceof Shelf) {
            this.shelves.remove(describe);
        }
    }
}

