/*
 * Decompiled with CFR 0.152.
 */
package net.isger.raw;

import java.io.File;
import java.io.FileFilter;
import net.isger.raw.FileDepot;
import net.isger.raw.JarShelf;
import net.isger.raw.Shelf;
import net.isger.util.Files;

public class JarDepot
extends FileDepot {
    private FileFilter FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile() && Files.isJar((String)file.getAbsolutePath());
        }
    };

    protected JarDepot() {
    }

    @Override
    protected boolean isMound(File file) {
        return super.isMound(file) || this.FILTER.accept(file);
    }

    @Override
    protected void addPath(File file) {
        if (file.isDirectory()) {
            for (File path : file.listFiles(this.FILTER)) {
                super.addPath(path);
            }
        } else {
            super.addPath(file);
        }
    }

    @Override
    protected Shelf createShelf(String path) {
        return new JarShelf(path);
    }
}

