/*
 * Decompiled with CFR 0.152.
 */
package net.isger.raw;

import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.isger.raw.Artifact;
import net.isger.raw.Depot;
import net.isger.raw.Prober;
import net.isger.raw.Raw;
import net.isger.raw.Wrapper;
import net.isger.util.Callable;
import net.isger.util.Files;
import net.isger.util.Helpers;
import net.isger.util.Reflects;
import net.isger.util.Strings;
import net.isger.util.hitch.Director;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Depository {
    private static final String KEY_DEPOSITORY = "brick.raw.depository";
    private static final String DEPOSITORY_PATH = "net/isger/raw";
    private static final String CONFIG_DEPOTSITORY = "depository.properties";
    private static final String KEY_DEPOT_CLASSES = "depot.classes";
    private static final String KEY_WRAPPER_CLASSES = "wrapper.classes";
    private static final Logger LOG = LoggerFactory.getLogger(Depository.class);
    private static final Object LOCKED = new Object();
    private static final Depository INSTANCE = new Depository();
    private Map<String, Depot> depots = new Hashtable<String, Depot>();
    private Map<String, Wrapper> wrappers = new Hashtable<String, Wrapper>();

    private Depository() {
    }

    public static void addDepot(Depot depot) {
        String name = depot.getClass().getName();
        if (LOG.isDebugEnabled()) {
            LOG.info("Achieve depot [{}]", (Object)name);
        }
        if ((depot = Depository.INSTANCE.depots.put(name, depot)) != null && LOG.isDebugEnabled()) {
            LOG.warn("(!) Discard depot [{}]", (Object)depot);
        }
    }

    public static void addWrapper(Wrapper wrapper) {
        String name = wrapper.getClass().getName();
        if (LOG.isDebugEnabled()) {
            LOG.info("Achieve wrapper [{}]", (Object)name);
        }
        if ((wrapper = Depository.INSTANCE.wrappers.put(name, wrapper)) != null && LOG.isDebugEnabled()) {
            LOG.warn("(!) Discard wrapper [{}]", (Object)wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Depot[] getDepots() {
        Depot[] depots;
        Object object = LOCKED;
        synchronized (object) {
            depots = Depository.INSTANCE.depots.values().toArray(new Depot[Depository.INSTANCE.depots.size()]);
        }
        return depots;
    }

    public static Depot getDepot(String name) {
        return Depository.INSTANCE.depots.get(name);
    }

    public static void mount(Object describe) {
        for (Depot depot : Depository.INSTANCE.depots.values()) {
            depot.mount(describe);
        }
    }

    public static Raw getRaw(String name) {
        return Depository.getRaw(name, null);
    }

    public static Raw getRaw(String name, Prober prober) {
        Raw raw = null;
        for (Depot depot : Depository.INSTANCE.depots.values()) {
            List<Raw> raws = depot.search(name, prober);
            if (raws.size() <= 0) continue;
            raw = raws.get(0);
            break;
        }
        return raw;
    }

    public static List<Raw> search(String name) {
        return Depository.search(name, null);
    }

    public static List<Raw> search(String name, Prober prober) {
        List<Raw> result = new ArrayList<Raw>();
        for (Depot depot : Depository.INSTANCE.depots.values()) {
            List<Raw> raws = depot.search(name, prober);
            if (raws == null) continue;
            result = Helpers.getMerge(result, raws);
        }
        return result;
    }

    public static Artifact getArtifact(String name) {
        return Depository.getArtifact(name, null);
    }

    public static Artifact getArtifact(String name, Prober prober) {
        Raw raw;
        Artifact artifact = null;
        Iterator<Raw> i$ = Depository.search(name, prober).iterator();
        while (i$.hasNext() && (artifact = Depository.getArtifact(raw = i$.next())) == null) {
        }
        return artifact;
    }

    public static Artifact getArtifact(Raw raw) {
        Wrapper wrapper;
        Artifact artifact = null;
        Iterator<Wrapper> i$ = Depository.INSTANCE.wrappers.values().iterator();
        while (i$.hasNext() && (artifact = (wrapper = i$.next()).wrap(raw)) == null) {
        }
        return artifact;
    }

    public static List<Artifact> wrap(String name) {
        return Depository.wrap(name, null);
    }

    public static List<Artifact> wrap(String name, Prober prober) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Raw raw : Depository.search(name, prober)) {
            Artifact artifact = Depository.getArtifact(raw);
            if (artifact == null) continue;
            artifacts.add(artifact);
        }
        return artifacts;
    }

    public static void unmount(Object describe) {
        for (Depot depot : Depository.INSTANCE.depots.values()) {
            depot.unmount(describe);
        }
    }

    static {
        Callable<Object> depotCall = new Callable<Object>(){

            public Object call(Object ... args) {
                Object instance = Reflects.newInstance((String)((String)args[0]));
                Depository.addDepot((Depot)instance);
                return instance;
            }
        };
        Callable<Object> wrapperCall = new Callable<Object>(){

            public Object call(Object ... args) {
                Object instance = Reflects.newInstance((String)((String)args[0]));
                Depository.addWrapper((Wrapper)instance);
                return instance;
            }
        };
        Callable<Object> mountCall = new Callable<Object>(){

            public Object call(Object ... args) {
                Depository.mount(args[0]);
                return null;
            }
        };
        new Director((Callable)depotCall, (Callable)wrapperCall, (Callable)mountCall){
            final /* synthetic */ Callable val$depotCall;
            final /* synthetic */ Callable val$wrapperCall;
            final /* synthetic */ Callable val$mountCall;
            {
                this.val$depotCall = callable;
                this.val$wrapperCall = callable2;
                this.val$mountCall = callable3;
            }

            protected String directPath() {
                return this.directPath(Depository.KEY_DEPOSITORY, Depository.DEPOSITORY_PATH);
            }

            protected void directAttach(String path) {
                path = Files.toPath((String)path, (String)Depository.CONFIG_DEPOTSITORY);
                for (URL url : Reflects.getResources((Object)((Object)this), (String)path)) {
                    Properties props = Helpers.getProperties((boolean)false, (URL)url);
                    Strings.each((StringTokenizer)this.getTokenizer(props, Depository.KEY_DEPOT_CLASSES), (Callable)this.val$depotCall);
                    Strings.each((StringTokenizer)this.getTokenizer(props, Depository.KEY_WRAPPER_CLASSES), (Callable)this.val$wrapperCall);
                }
            }

            protected void directInflux() {
                URL url = Reflects.getResource((Object)INSTANCE, (String)"/");
                if (url == null) {
                    Depository.mount("./");
                } else {
                    Depository.mount(url);
                }
                Strings.each((StringTokenizer)this.getSystemTokenizer("java.class.path"), (Callable)this.val$mountCall);
                Strings.each((StringTokenizer)this.getSystemTokenizer("java.lib.path"), (Callable)this.val$mountCall);
            }
        }.direct((Object)INSTANCE);
    }
}

