/*
 * Decompiled with CFR 0.152.
 */
package net.isger.raw;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import net.isger.raw.AbstractDepot;
import net.isger.raw.BaseRaw;
import net.isger.raw.Depot;
import net.isger.raw.Raw;
import net.isger.raw.Shelf;
import net.isger.util.Reflects;

public class BaseDepot
extends AbstractDepot {
    private static final Depot DEPOT = new BaseDepot();
    private ClassLoader loader = Reflects.getClassLoader((Object)this);

    private BaseDepot() {
        super.mount(new Shelf(){

            @Override
            public Object getResource(String name) {
                ArrayList<URL> result = new ArrayList<URL>();
                try {
                    Enumeration<URL> urls = BaseDepot.this.loader.getResources(name);
                    while (urls.hasMoreElements()) {
                        result.add(urls.nextElement());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return result;
            }

            public String toString() {
                return BaseDepot.this.loader.getClass().getName();
            }
        });
    }

    public static Depot getInstance() {
        return DEPOT;
    }

    @Override
    public void mount(Object stack) {
    }

    @Override
    protected List<Raw> createRaws(Object resource) {
        ArrayList<Raw> raws = new ArrayList<Raw>();
        List urls = (List)resource;
        for (URL url : urls) {
            raws.add(this.createRaw(url));
        }
        return raws;
    }

    protected Raw createRaw(URL url) {
        return url == null ? null : new BaseRaw(url);
    }

    @Override
    public void unmount(Object stack) {
    }
}

