/*
 * Decompiled with CFR 0.152.
 */
package net.isger.raw;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.isger.raw.Depot;
import net.isger.raw.Prober;
import net.isger.raw.Raw;
import net.isger.raw.Shelf;
import net.isger.util.Callable;
import net.isger.util.Helpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDepot
implements Depot {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDepot.class);
    private static final Callable<List<Object>> NOP = new Callable<List<Object>>(){
        private List<Object> EMPTY = Collections.unmodifiableList(new ArrayList());

        public List<Object> call(Object ... args) {
            return this.EMPTY;
        }
    };
    private List<Shelf> shelves = new ArrayList<Shelf>();

    protected AbstractDepot() {
    }

    @Override
    public void mount(Object describe) {
        if (describe instanceof Shelf && !this.shelves.contains(describe)) {
            if (LOG.isDebugEnabled()) {
                LOG.info("Achieve shelf [{}]", describe);
            }
            this.shelves.add((Shelf)describe);
        }
    }

    @Override
    public final List<Raw> search(String name, final Prober prober) {
        Callable<List<Object>> callable = prober == null ? NOP : new Callable<List<Object>>(){

            public List<Object> call(Object ... args) {
                return prober.probe((Shelf)args[0], (String)args[1]);
            }
        };
        List<Raw> result = new ArrayList<Raw>();
        for (Shelf stack : this.shelves) {
            result = this.createRaws(stack.getResource(name));
            for (Object resource : (List)callable.call(new Object[]{stack, name})) {
                result = Helpers.getMerge(result, this.createRaws(resource));
            }
        }
        return result;
    }

    protected abstract List<Raw> createRaws(Object var1);

    @Override
    public void unmount(Object describe) {
        if (describe instanceof Shelf) {
            this.shelves.remove(describe);
        }
    }
}

