/*
 * Decompiled with CFR 0.152.
 */
package net.isger.raw;

import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import net.isger.raw.AbstractArtifact;
import net.isger.raw.GsonAdapter;
import net.isger.raw.Raw;
import net.isger.util.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonArtifact
extends AbstractArtifact {
    private static final Logger LOG = LoggerFactory.getLogger(GsonArtifact.class);
    private GsonBuilder builder = new GsonBuilder();

    public GsonArtifact(Raw raw) {
        super(raw);
        this.builder.registerTypeAdapterFactory(GsonAdapter.FACTORY);
    }

    public Object use(String id, Object ... args) {
        Object result = null;
        if (id.equalsIgnoreCase("transform")) {
            result = args != null && args.length > 1 ? this.transform((Class)args[0], (String)args[1]) : this.transform();
        }
        return result;
    }

    public Object transform() {
        return this.transform(Object.class, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T transform(Class<T> type, String charsetName) {
        Object result = null;
        Raw raw = this.getRaw();
        InputStreamReader reader = null;
        try {
            reader = charsetName == null ? new InputStreamReader(raw.getInputStream()) : new InputStreamReader(raw.getInputStream(), charsetName);
            result = this.builder.create().fromJson((Reader)reader, type);
        }
        catch (Exception e) {
            try {
                LOG.warn("(!) Unable to transform [{}]", raw.getSource(), (Object)e.getCause());
            }
            catch (Throwable throwable) {
                Files.close(reader);
                throw throwable;
            }
            Files.close((Closeable)reader);
        }
        Files.close((Closeable)reader);
        return (T)result;
    }
}

