/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.typeutils;

import java.lang.reflect.Parameter;
import java.util.UUID;
import net.inveed.typeutils.JavaTypeDesc;
import net.inveed.typeutils.JavaTypeRegistry;
import net.inveed.typeutils.NativeTypeDesc;
import net.inveed.typeutils.annotation.ParameterName;

public class TypeUtils {
    public static Object toObject(JavaTypeDesc<?> type, Object id) {
        if (id == null) {
            return null;
        }
        return TypeUtils.toObject(type, id.toString());
    }

    public static Object toObject(JavaTypeDesc<?> t, String id) {
        if (t instanceof NativeTypeDesc) {
            NativeTypeDesc type = (NativeTypeDesc)t;
            if (type.isString()) {
                return id;
            }
            if (type.isBoolean()) {
                return Boolean.parseBoolean(id);
            }
            if (type.isByte()) {
                return Byte.parseByte(id);
            }
            if (type.isShort()) {
                return Short.parseShort(id);
            }
            if (type.isInt()) {
                return Integer.parseInt(id);
            }
            if (type.isLong()) {
                return Long.parseLong(id);
            }
            if (type.isFloat()) {
                return Float.valueOf(Float.parseFloat(id));
            }
            if (type.isDouble()) {
                return Double.parseDouble(id);
            }
            if (type.isUUID()) {
                return UUID.fromString(id);
            }
        }
        return null;
    }

    public static ArgumentMatch getArgumentMatches(Object[] values, Parameter[] params, String[] nameHints) {
        if (values == null) {
            return null;
        }
        if (params == null) {
            return null;
        }
        if (params.length != values.length) {
            return null;
        }
        if (nameHints == null) {
            nameHints = new String[values.length];
        }
        Integer[] hardParamMap = new Integer[params.length];
        Integer[] hardValueMap = new Integer[values.length];
        boolean[] needConvert = new boolean[values.length];
        block0: for (int ni = 0; ni < nameHints.length; ++ni) {
            String name = nameHints[ni];
            if (name == null) continue;
            Class<?> vtype = null;
            if (values[ni] != null) {
                vtype = values[ni].getClass();
            }
            for (int pi = 0; pi < params.length; ++pi) {
                Parameter p = params[pi];
                ParameterName annArgName = p.getAnnotation(ParameterName.class);
                if (annArgName == null || !annArgName.value().equals(name) || vtype == null) continue;
                if (p.getType().isAssignableFrom(vtype)) {
                    hardParamMap[pi] = ni;
                    hardValueMap[ni] = pi;
                    continue block0;
                }
                Object convValue = TypeUtils.toObject(JavaTypeRegistry.getType(p.getType()), values[ni]);
                if (convValue != null) {
                    if (p.getType().isAssignableFrom(convValue.getClass())) {
                        hardParamMap[pi] = ni;
                        hardValueMap[ni] = pi;
                        needConvert[ni] = true;
                        continue block0;
                    }
                    return null;
                }
                if (!p.getType().isPrimitive()) continue block0;
                return null;
            }
        }
        boolean cont = true;
        int globalScore = 0;
        while (cont) {
            int score;
            cont = false;
            while ((score = TypeUtils.tryAddNotNullToMap(values, params, hardParamMap, hardValueMap)) > 0) {
                globalScore += score * 5;
                cont = true;
            }
            score = TypeUtils.tryAddNotNullConvertedToMap(values, params, hardParamMap, hardValueMap, needConvert);
            if (score > 0) {
                globalScore += score * 2;
                cont = true;
            }
            if ((score = TypeUtils.tryAddNullToMap(values, params, hardParamMap, hardValueMap)) <= 0) continue;
            globalScore += score;
            cont = true;
        }
        boolean ok = true;
        for (Integer i : hardValueMap) {
            if (i != null) continue;
            ok = false;
        }
        if (!ok) {
            return null;
        }
        return new ArgumentMatch(globalScore, hardParamMap, values, params);
    }

    private static int tryAddNullToMap(Object[] values, Parameter[] params, Integer[] hardParamMap, Integer[] hardValueMap) {
        int ret = 0;
        for (int pi = 0; pi < hardParamMap.length; ++pi) {
            if (hardParamMap[pi] != null) continue;
            Parameter p = params[pi];
            Integer supportedValueIndex = null;
            boolean ok = true;
            for (int vi = 0; vi < hardValueMap.length; ++vi) {
                Object val;
                if (hardValueMap[vi] != null || (val = values[vi]) != null || p.getType().isPrimitive()) continue;
                if (supportedValueIndex != null) {
                    ok = false;
                    break;
                }
                supportedValueIndex = vi;
            }
            if (!ok || supportedValueIndex == null) continue;
            hardValueMap[supportedValueIndex.intValue()] = pi;
            hardParamMap[pi] = supportedValueIndex;
            ++ret;
        }
        return ret;
    }

    private static int tryAddNotNullConvertedToMap(Object[] values, Parameter[] params, Integer[] hardParamMap, Integer[] hardValueMap, boolean[] needConvert) {
        int ret = 0;
        for (int pi = 0; pi < hardParamMap.length; ++pi) {
            if (hardParamMap[pi] != null) continue;
            Parameter p = params[pi];
            Integer supportedValueIndex = null;
            boolean ok = true;
            for (int vi = 0; vi < hardValueMap.length; ++vi) {
                Object convVal;
                Object val;
                if (hardValueMap[vi] != null || (val = values[vi]) == null || (convVal = TypeUtils.toObject(JavaTypeRegistry.getType(p.getType()), val)) == null || !p.getType().isAssignableFrom(convVal.getClass())) continue;
                if (supportedValueIndex != null) {
                    ok = false;
                    break;
                }
                supportedValueIndex = vi;
            }
            if (!ok || supportedValueIndex == null) continue;
            hardValueMap[supportedValueIndex.intValue()] = pi;
            hardParamMap[pi] = supportedValueIndex;
            needConvert[supportedValueIndex.intValue()] = true;
            ++ret;
        }
        return ret;
    }

    private static int tryAddNotNullToMap(Object[] values, Parameter[] params, Integer[] hardParamMap, Integer[] hardValueMap) {
        int ret = 0;
        for (int pi = 0; pi < hardParamMap.length; ++pi) {
            if (hardParamMap[pi] != null) continue;
            Parameter p = params[pi];
            Integer supportedValueIndex = null;
            boolean ok = true;
            for (int vi = 0; vi < hardValueMap.length; ++vi) {
                Object val;
                if (hardValueMap[vi] != null || (val = values[vi]) == null || !p.getType().isAssignableFrom(val.getClass())) continue;
                if (supportedValueIndex != null) {
                    ok = false;
                    break;
                }
                supportedValueIndex = vi;
            }
            if (!ok || supportedValueIndex == null) continue;
            hardValueMap[supportedValueIndex.intValue()] = pi;
            hardParamMap[pi] = supportedValueIndex;
            ++ret;
        }
        return ret;
    }

    public static final class ArgumentMatch {
        private final int score;
        private final Object[] sorted;

        public ArgumentMatch(int score, Integer[] hardParamMap, Object[] values, Parameter[] params) {
            this.score = score;
            Object[] sorted = new Object[values.length];
            for (int i = 0; i < params.length; ++i) {
                sorted[i] = values[hardParamMap[i]];
            }
            this.sorted = sorted;
        }

        public int getScore() {
            return this.score;
        }

        public Object[] getSorted() {
            return this.sorted;
        }
    }
}

