/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.typeutils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.inveed.typeutils.AccessLevel;
import net.inveed.typeutils.annotation.PropertyGetter;

public class PropertyUtils {
    private static final boolean isCasableChar(char c) {
        return Character.isUpperCase(c) || Character.isLowerCase(c);
    }

    public static final String normalizePropertyName(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() >= 2 && Character.isUpperCase(name.charAt(0)) && !PropertyUtils.isCasableChar(name.charAt(1))) {
            return name;
        }
        if (name.length() > 2 && Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1)) && (Character.isUpperCase(name.charAt(2)) || !PropertyUtils.isCasableChar(name.charAt(2)))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static final AccessLevel getAccessLevel(Method m) {
        if (m == null) {
            return AccessLevel.ABSENT;
        }
        int mod = m.getModifiers();
        if (Modifier.isPublic(mod)) {
            return AccessLevel.PUBLIC;
        }
        if (Modifier.isProtected(mod)) {
            return AccessLevel.PROTECTED;
        }
        if (Modifier.isPrivate(mod)) {
            return AccessLevel.PRIVATE;
        }
        return AccessLevel.DEFAULT;
    }

    public static final AccessLevel getAccessLevel(Field f) {
        if (f == null) {
            return AccessLevel.ABSENT;
        }
        int mod = f.getModifiers();
        if (Modifier.isPublic(mod)) {
            return AccessLevel.PUBLIC;
        }
        if (Modifier.isProtected(mod)) {
            return AccessLevel.PROTECTED;
        }
        if (Modifier.isPrivate(mod)) {
            return AccessLevel.PRIVATE;
        }
        return AccessLevel.DEFAULT;
    }

    public static final AccessibleObject select(Field field, Method method, int requiredFieldLevel, int requiredMethodLevel) {
        boolean hasMethodAnnotation;
        boolean hasFieldAnnotation;
        boolean canUseMethod;
        boolean canUseField;
        if (field == null && method == null) {
            return null;
        }
        int fieldLvl = PropertyUtils.getAccessLevel(field).getLevel();
        int methodLvl = PropertyUtils.getAccessLevel(method).getLevel();
        boolean bl = field != null ? fieldLvl >= requiredFieldLevel : (canUseField = false);
        boolean bl2 = method != null ? methodLvl >= requiredMethodLevel : (canUseMethod = false);
        boolean bl3 = field != null ? field.getAnnotation(PropertyGetter.class) != null : (hasFieldAnnotation = false);
        boolean bl4 = method != null ? method.getAnnotation(PropertyGetter.class) != null : (hasMethodAnnotation = false);
        if (!(canUseField || hasFieldAnnotation || canUseMethod || hasMethodAnnotation)) {
            return null;
        }
        if (!canUseField && !hasFieldAnnotation && (canUseMethod || hasMethodAnnotation)) {
            return method;
        }
        if ((canUseField || hasFieldAnnotation) && !canUseMethod && !hasMethodAnnotation) {
            return field;
        }
        if (hasFieldAnnotation && !hasMethodAnnotation) {
            return field;
        }
        if (hasMethodAnnotation && !hasFieldAnnotation) {
            return method;
        }
        if (canUseField && !canUseMethod) {
            return field;
        }
        if (canUseMethod && !canUseField) {
            return method;
        }
        if (fieldLvl > methodLvl) {
            return field;
        }
        if (methodLvl > fieldLvl) {
            return method;
        }
        return method;
    }
}

