/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.typeutils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import net.inveed.commons.utils.ReflectionUtils;
import net.inveed.typeutils.ext.IParameterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParameterMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(ParameterMetadata.class);
    private final String name;
    private final Class<?> type;
    private final Type genericType;
    private final Annotation[] annotations;
    private final int index;
    private final HashMap<Class<? extends IParameterExtension>, IParameterExtension> extensions = new HashMap();

    ParameterMetadata(String name, Class<?> type, Type genericType, int index, Annotation[] annotations) {
        this.name = name;
        this.type = type;
        this.genericType = genericType;
        this.index = index;
        this.annotations = annotations;
    }

    public <A extends Annotation> A getAnnotation(Class<A> type) {
        return (A)ReflectionUtils.getAnnotation((Annotation[])this.annotations, type);
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public <E extends IParameterExtension> E getExtension(Class<E> type) {
        return (E)this.extensions.get(type);
    }

    public void registerExtension(IParameterExtension ext) {
        if (this.extensions.containsKey(ext.getClass())) {
            LOG.error("Trying to register extension with type {} twice. ", ext.getClass());
            return;
        }
        this.extensions.put(ext.getClass(), ext);
    }

    public String toString() {
        if (this.getName() == null) {
            return this.type.toString();
        }
        return this.getName() + "(" + this.type.toString() + ")";
    }
}

