/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.typeutils;

import java.util.Date;
import java.util.UUID;
import net.inveed.typeutils.JavaTypeDesc;

public final class NativeTypeDesc<T>
extends JavaTypeDesc<T> {
    private Class<T> type;

    NativeTypeDesc(Class<T> type) {
        this.type = type;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    public boolean isByte() {
        return this.type == Byte.TYPE || this.type == Byte.class;
    }

    public boolean isShort() {
        return this.type == Short.TYPE || this.type == Short.class;
    }

    public boolean isInt() {
        return this.type == Integer.class || this.type == Integer.TYPE;
    }

    public boolean isLong() {
        return this.type == Long.TYPE || this.type == Long.class;
    }

    public boolean isFloat() {
        return this.type == Float.TYPE || this.type == Float.class;
    }

    public boolean isDouble() {
        return this.type == Double.TYPE || this.type == Double.class;
    }

    public boolean isBoolean() {
        return this.type == Boolean.TYPE || this.type == Boolean.class;
    }

    public boolean isChar() {
        return this.type == Character.TYPE || this.type == Character.class;
    }

    public boolean isString() {
        return this.type == String.class;
    }

    public boolean isDate() {
        return this.type == Date.class;
    }

    public boolean isUUID() {
        return this.type == UUID.class;
    }

    @Override
    public boolean isAssignableFrom(JavaTypeDesc<?> type) {
        if (this.getType() == Long.class && type.getType() == Long.TYPE) {
            return true;
        }
        if (this.getType() == Integer.class && type.getType() == Integer.TYPE) {
            return true;
        }
        if (this.getType() == Short.class && type.getType() == Short.TYPE) {
            return true;
        }
        if (this.getType() == Byte.class && type.getType() == Byte.TYPE) {
            return true;
        }
        if (this.getType() == Double.class && type.getType() == Double.TYPE) {
            return true;
        }
        if (this.getType() == Float.class && type.getType() == Float.TYPE) {
            return true;
        }
        if (this.getType() == Character.class && type.getType() == Character.TYPE) {
            return true;
        }
        return super.isAssignableFrom(type);
    }
}

