/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.typeutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.inveed.typeutils.ArrayTypeDesc;
import net.inveed.typeutils.BeanTypeDesc;
import net.inveed.typeutils.EnumTypeDesc;
import net.inveed.typeutils.JavaTypeDesc;
import net.inveed.typeutils.ListTypeDesc;
import net.inveed.typeutils.MapTypeDesc;
import net.inveed.typeutils.NativeTypeDesc;
import net.inveed.typeutils.ext.IBeanTypeExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaTypeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(JavaTypeRegistry.class);
    private static final HashMap<Class<?>, JavaTypeDesc<?>> classMap = new HashMap();
    private static final ArrayList<Class<? extends IBeanTypeExtension<?>>> extensions = new ArrayList();

    private static final IBeanTypeExtension<?> instantiateExtension(BeanTypeDesc<?> btd, Class<? extends IBeanTypeExtension> type) {
        try {
            Constructor<? extends IBeanTypeExtension> ctr = type.getConstructor(BeanTypeDesc.class);
            return ctr.newInstance(btd);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOG.warn("Cannot instantiate extension for type " + type.getName(), (Throwable)e);
            return null;
        }
    }

    public static final List<EnumTypeDesc<?>> getEnums() {
        ArrayList ret = new ArrayList();
        for (JavaTypeDesc<?> td : classMap.values()) {
            if (!(td instanceof EnumTypeDesc)) continue;
            ret.add((EnumTypeDesc)td);
        }
        return ret;
    }

    public static final void registerExtension(Class<? extends IBeanTypeExtension> type) {
        for (JavaTypeDesc<?> t : classMap.values()) {
            BeanTypeDesc btd;
            IBeanTypeExtension<?> bte;
            if (!(t instanceof BeanTypeDesc) || (bte = JavaTypeRegistry.instantiateExtension(btd = (BeanTypeDesc)t, type)) == null || !bte.isValid()) continue;
            btd.registerExtension(bte);
        }
        extensions.add(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> JavaTypeDesc<T> getType(Class<T> type) {
        if (classMap.containsKey(type)) {
            return classMap.get(type);
        }
        HashMap<Class<?>, JavaTypeDesc<?>> hashMap = classMap;
        synchronized (hashMap) {
            if (classMap.containsKey(type)) {
                return classMap.get(type);
            }
            JavaTypeDesc<T> t = null;
            if (type instanceof Class) {
                t = JavaTypeRegistry.createFor(type);
            }
            classMap.put(type, t);
            return t;
        }
    }

    private static final <T> JavaTypeDesc<T> createFor(Class<T> type) {
        if (type.isPrimitive() || type == Class.class || type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == Boolean.class || type == Character.class || type == String.class || type == UUID.class || type == Date.class) {
            return new NativeTypeDesc<T>(type);
        }
        if (type.isArray()) {
            JavaTypeDesc<?> elementType = JavaTypeRegistry.getType(type.getComponentType());
            return new ArrayTypeDesc(type, elementType);
        }
        if (type.isEnum()) {
            return new EnumTypeDesc<T>(type);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return new ListTypeDesc((Class<? extends Collection<?>>)type);
        }
        if (Map.class.isAssignableFrom(type)) {
            return new MapTypeDesc((Class<? extends Map<?, ?>>)type);
        }
        BeanTypeDesc ret = new BeanTypeDesc(type);
        for (Class<? extends IBeanTypeExtension<?>> clazz : extensions) {
            IBeanTypeExtension<?> e = JavaTypeRegistry.instantiateExtension(ret, clazz);
            if (!e.isValid()) continue;
            ret.registerExtension(e);
        }
        return ret;
    }

    private JavaTypeRegistry() {
    }
}

