/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.typeutils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import net.inveed.commons.annotations.EnumDisplayValue;
import net.inveed.typeutils.JavaTypeDesc;

public final class EnumTypeDesc<T extends Enum<T>>
extends JavaTypeDesc<T> {
    private static final HashMap<String, EnumTypeDesc<?>> registeredEnums = new HashMap();
    private Class<T> type;
    private AccessibleObject displayValueGetter;

    public static final EnumTypeDesc<?> getEnum(String name) {
        return registeredEnums.get(name);
    }

    EnumTypeDesc(Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.type = type;
        this.parse();
        registeredEnums.put(this.getName(), this);
    }

    private void parse() {
        for (Method method : this.type.getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || method.getReturnType() != String.class || method.getParameterCount() > 0 || method.getAnnotation(EnumDisplayValue.class) == null) continue;
            this.displayValueGetter = method;
            break;
        }
        if (this.displayValueGetter == null) {
            for (AccessibleObject accessibleObject : this.type.getFields()) {
                if (Modifier.isAbstract(((Field)accessibleObject).getModifiers()) || ((Field)accessibleObject).getType() != String.class || ((Field)accessibleObject).getAnnotation(EnumDisplayValue.class) == null) continue;
                this.displayValueGetter = accessibleObject;
                break;
            }
        }
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    public String getName() {
        return this.type.getSimpleName();
    }

    public T getEnumValue(String val) {
        T ret = Enum.valueOf(this.getType(), val);
        if (ret == null) {
            System.err.println("Cannot find enum value " + val + " for type " + this.getName());
        }
        return ret;
    }

    public String getDisplayValue(T value) {
        if (value == null) {
            return null;
        }
        if (this.displayValueGetter == null) {
            return ((Enum)value).toString();
        }
        if (this.displayValueGetter instanceof Method) {
            Method m = (Method)this.displayValueGetter;
            try {
                return (String)m.invoke(value, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                return ((Enum)value).toString();
            }
        }
        Field f = (Field)this.displayValueGetter;
        try {
            return (String)f.get(value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return ((Enum)value).toString();
        }
    }

    public T[] getDeclaredValues() {
        return (Enum[])this.getType().getEnumConstants();
    }

    public String getDisplayValue(Object e) {
        if (e == null) {
            return null;
        }
        if (!this.getType().isAssignableFrom(e.getClass())) {
            return null;
        }
        return this.getDisplayValue((T)((Enum)e));
    }
}

